/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Set;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.delivery.module.streamregistry.IStreamRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownstreamCopy
implements IPreParsingHook {
    static final Logger log = LoggerFactory.getLogger(DownstreamCopy.class);
    final IMessageGroup group;
    final IStreamRegistry registry;

    public DownstreamCopy(IStreamRegistry sr, IMessageGroup group) {
        this.registry = sr;
        this.group = group;
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.group;
    }

    @Override
    public boolean processUnParsedMessage(MessageWrapper mw) {
        ByteBuf buf = (ByteBuf)mw.msg();
        byte[] rawData = new byte[buf.readableBytes()];
        buf.readBytes(rawData);
        StreamNameCode code = new StreamNameCode();
        Set<IEndPoint> epset = this.registry.getConsumingEndPoints(this.group.id(), mw.getMetaInformation(code));
        for (IEndPoint ep : epset) {
            if (ep == mw.getEndpoint()) continue;
            ByteBuf bufNew = ((EndPoint)ep).getChannel().alloc().buffer();
            bufNew.writeBytes(rawData);
            MessageWrapper mwNew = new MessageWrapper(bufNew, mw.getMessageClass());
            mwNew.setMetaInformation(mw.getMetaInformation());
            mwNew.encodeMessage(false);
            try {
                ep.send(mwNew);
            }
            catch (Exception e) {
                log.error("Unable to broadcast message to " + ep + ". " + e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
            }
        }
        return false;
    }
}

