/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import jayeson.service.delivery.DeliveryConfig;
import jayeson.service.delivery.DeliveryModule;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

@Singleton
public class RubyDeliveryFactory {
    public Injector create() throws InstantiationException {
        return this.createInjector(new DeliveryModule());
    }

    public Injector create(String filename, String path) throws InstantiationException {
        return this.create(RubyDeliveryFactory.searchForConfig(filename, path));
    }

    public Injector create(DeliveryConfig config) throws InstantiationException {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        return this.createInjector(new DeliveryModule(config));
    }

    Injector createInjector(DeliveryModule module) throws InstantiationException {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        return injector;
    }

    static DeliveryConfig searchForConfig(String confFilename, String confSysVar) {
        DeliveryConfig conf = (DeliveryConfig)JacksonConfig.readConfig((String)confFilename, (String)confSysVar, DeliveryConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        if (conf == null) {
            throw new RuntimeException("Cannot find delivery configuration!! Please check class path");
        }
        return conf;
    }
}

