/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddFormat;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.feed.basketball.BasketballEvent;
import jayeson.lib.feed.basketball.BasketballEventImpl;
import jayeson.lib.feed.basketball.BasketballEventState;
import jayeson.lib.feed.basketball.BasketballEventType;
import jayeson.lib.feed.basketball.BasketballGender;
import jayeson.lib.feed.basketball.BasketballMatch;
import jayeson.lib.feed.basketball.BasketballMatchImpl;
import jayeson.lib.feed.basketball.BasketballRecord;
import jayeson.lib.feed.basketball.BasketballRecordImpl;
import jayeson.lib.feed.basketball.BasketballSegment;
import jayeson.lib.feed.basketball.BasketballStats;
import jayeson.lib.feed.basketball.BasketballTimeType;
import jayeson.lib.sports.codec.CodecHelper;
import jayeson.lib.sports.codec.EncodeAction;
import jayeson.lib.sports.codec.ICodec;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.protobuf.Basketball;
import jayeson.lib.sports.protobuf.Sports;

class BasketballCodec
implements ICodec {
    private CodecHelper codecHelper;

    @Inject
    public BasketballCodec(CodecHelper codecHelper) {
        this.codecHelper = codecHelper;
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof BasketballMatch) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeMatch(in, pool);
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool) {
        BasketballMatch input = (BasketballMatch)in;
        Sports.BaseMatch.Builder baseMatchBuilder = this.codecHelper.getBasketballMatchBuilder(in, pool);
        Basketball.BasketballMatch.Builder bbMatchBuilder = Basketball.BasketballMatch.newBuilder();
        if (input.gender() != null) {
            bbMatchBuilder.setGender(Basketball.BasketballMatch.Gender.valueOf(input.gender().name()));
        }
        baseMatchBuilder.setBasketballMatch(bbMatchBuilder);
        return baseMatchBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof BasketballEvent) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        BasketballEvent input = (BasketballEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getBasketballEventBuilder(in, pool);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setBasketballEventType(Basketball.BasketballEvent.Type.valueOf(input.eventType().name()));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool, key);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool) {
        BasketballEvent input = (BasketballEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getBasketballEventBuilder(in, pool);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setBasketballEventType(Basketball.BasketballEvent.Type.valueOf(input.eventType().name()));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, EncodeAction action, boolean excludeRateId, PartitionKey key) {
        if (!(in instanceof BasketballRecord) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeRecord(in, pool, excludeRateId);
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, boolean excludeRateId) {
        Sports.BaseRecord.Builder baseRecordBuilder = this.codecHelper.getBaseRecordBuilder(in, pool, excludeRateId);
        baseRecordBuilder.setTimeType(this.encodeTimeType(in.timeType()));
        BasketballRecord bbRecord = (BasketballRecord)in;
        Basketball.BasketballRecord.Builder bbBuilder = Basketball.BasketballRecord.newBuilder();
        bbBuilder.setSwapped(bbRecord.isSwapped());
        baseRecordBuilder.setBasketballRecord(bbBuilder.build());
        return baseRecordBuilder.build();
    }

    private Sports.BaseEventState encodeState(IBetEventState in, StringPool pool, PartitionKey key) {
        if (!(in instanceof BasketballEventState) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeState(in, pool);
    }

    private Sports.BaseEventState encodeState(IBetEventState in, StringPool pool) {
        BasketballEventState bbEventState = (BasketballEventState)in;
        Sports.BaseEventState.Builder baseEventStateBuilder = this.codecHelper.getBaseEventStateBuilder(in, pool);
        Basketball.BasketballEventState.Builder bbEventStateBuilder = Basketball.BasketballEventState.newBuilder();
        bbEventStateBuilder.setSegment(Basketball.BasketballEventState.Segment.valueOf(bbEventState.segment().name()));
        bbEventStateBuilder.setTimeout(bbEventState.isTimeout());
        bbEventStateBuilder.setBookPriority(bbEventState.bookPriority());
        baseEventStateBuilder.setBasketballEventState(bbEventStateBuilder);
        return baseEventStateBuilder.build();
    }

    private IBetMatch getMatch(String id, Collection<BasketballEvent> events, String host, String guest, long startTime, String league, BasketballGender gender, String country, Map<String, String> meta) {
        return new BasketballMatchImpl(host, guest, startTime, events, id, league, gender, country, meta);
    }

    @Override
    public Collection<IBetMatch> decodeMatch(Collection<Sports.BaseMatch> in, List<String> pool, EncodeAction action, PartitionKey key) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        for (Sports.BaseMatch baseMatch : in) {
            String id = pool.get(baseMatch.getId());
            String host = null;
            String guest = null;
            long startTime = 0L;
            List<BasketballEvent> events = Arrays.asList(new BasketballEvent[0]);
            String league = null;
            BasketballGender gender = null;
            String country = null;
            Map<String, String> meta = null;
            host = pool.get(baseMatch.getParticipants(0));
            guest = pool.get(baseMatch.getParticipants(1));
            startTime = baseMatch.getStartTime();
            league = pool.get(baseMatch.getLeague());
            meta = new HashMap<String, String>(baseMatch.getMetaInfoMap());
            if (baseMatch.getBasketballMatch().getGender() != null) {
                gender = BasketballGender.valueOf((String)baseMatch.getBasketballMatch().getGender().name());
            }
            country = pool.get(baseMatch.getCountry());
            if (key != null) {
                meta = CodecHelper.populatePKIntoMetaInfo(meta, key);
            }
            IBetMatch curr = this.getMatch(id, events, host, guest, startTime, league, gender, country, meta);
            result.add(curr);
        }
        return result;
    }

    private BasketballEvent getEvent(String id, Collection<BasketballRecord> records, Collection<BasketballEventState> states, String matchId, BasketballEventType type, Map<String, String> meta) {
        return new BasketballEventImpl(id, records, states, matchId, (EventType)type, meta);
    }

    @Override
    public Collection<IBetMatch> decodeEvent(Collection<Sports.BaseEvent> in, List<String> pool, EncodeAction action, PartitionKey partition) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        HashMap<String, List> matchIdToEvents = new HashMap<String, List>();
        for (Sports.BaseEvent baseEvent : in) {
            String id = pool.get(baseEvent.getId());
            String matchId = pool.get(baseEvent.getMatchId());
            List<BasketballRecord> records = Arrays.asList(new BasketballRecord[0]);
            List<BasketballEventState> states = Arrays.asList(this.decodeState(matchId, id, baseEvent.getState(), pool, action, partition));
            BasketballEventType type = null;
            HashMap<String, String> meta = null;
            meta = new HashMap<String, String>(baseEvent.getMetaInfoMap());
            type = BasketballEventType.valueOf((String)baseEvent.getEventType().getBasketballEventType().name());
            BasketballEvent event = this.getEvent(id, records, states, matchId, type, meta);
            List events = matchIdToEvents.computeIfAbsent(matchId, currMatchId -> new ArrayList());
            events.add(event);
        }
        for (Map.Entry entry : matchIdToEvents.entrySet()) {
            String matchId = (String)entry.getKey();
            IBetMatch currMatch = this.getMatch(matchId, (Collection)entry.getValue(), null, null, 0L, null, null, null, new HashMap<String, String>());
            result.add(currMatch);
        }
        return result;
    }

    @Override
    public Collection<IBetMatch> decodeRecord(Collection<Sports.BaseRecord> in, List<String> pool, EncodeAction action, PartitionKey partition) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        HashMap<String, Map> groupEventsByMatchIdAndEventId = new HashMap<String, Map>();
        HashMap<String, Map> matchEventIdToRecords = new HashMap<String, Map>();
        for (Sports.BaseRecord baseRecord : in) {
            long id = baseRecord.getId();
            OddType oddType = null;
            LBType lbType = null;
            BasketballTimeType timeType = null;
            String sportbook = pool.get(baseRecord.getSource());
            OddFormat oddFormat = null;
            Map<String, String> meta = null;
            float rateOver = 0.0f;
            float rateUnder = 0.0f;
            float rateEqual = 0.0f;
            String rateOverId = null;
            String rateUnderId = null;
            String rateEqualId = null;
            float pivotValue = 0.0f;
            PivotType pivotType = null;
            PivotBias pivotBias = null;
            oddType = OddType.valueOf((String)baseRecord.getOddType().name());
            lbType = LBType.valueOf((String)baseRecord.getLbType().name());
            timeType = BasketballTimeType.valueOf((String)baseRecord.getTimeType().getBasketballTimeType().getSettle().name());
            sportbook = pool.get(baseRecord.getSource());
            oddFormat = OddFormat.valueOf((String)baseRecord.getFormat().name());
            meta = baseRecord.getMetaInfoMap();
            try {
                rateOver = baseRecord.getRates(0);
                rateUnder = baseRecord.getRates(1);
                rateEqual = baseRecord.getRates(2);
                pivotValue = baseRecord.getPivotValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pivotType = PivotType.valueOf((String)baseRecord.getPivotType().name());
            pivotBias = PivotBias.valueOf((String)baseRecord.getPivotBias().name());
            try {
                rateOverId = pool.get(baseRecord.getRateIds(0));
                rateUnderId = pool.get(baseRecord.getRateIds(1));
                rateEqualId = pool.get(baseRecord.getRateIds(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String matchId = pool.get(baseRecord.getMatchId());
            String eventId = pool.get(baseRecord.getEventId());
            boolean isSwapped = baseRecord.getBasketballRecord().getSwapped();
            BasketballRecordImpl basketballRecord = new BasketballRecordImpl(matchId, eventId, id, oddType, lbType, (TimeType)timeType, sportbook, oddFormat, meta, rateOver, rateUnder, rateEqual, pivotValue, pivotType, pivotBias, rateOverId, rateUnderId, rateEqualId, isSwapped);
            Map eventMapping = matchEventIdToRecords.computeIfAbsent(matchId, key -> new HashMap());
            ArrayList recordsList = eventMapping.computeIfAbsent(eventId, key -> new ArrayList());
            recordsList.add(basketballRecord);
            Map basketballEventMap = groupEventsByMatchIdAndEventId.computeIfAbsent(matchId, key -> new HashMap());
            basketballEventMap.computeIfAbsent(eventId, key -> this.getEvent(eventId, recordsList, null, matchId, null, new HashMap<String, String>()));
        }
        for (Map.Entry entry : groupEventsByMatchIdAndEventId.entrySet()) {
            String matchId = (String)entry.getKey();
            result.add(this.getMatch(matchId, ((Map)entry.getValue()).values(), null, null, 0L, null, null, null, new HashMap<String, String>()));
        }
        return result;
    }

    public BasketballEventState decodeState(String matchId, String eventId, Sports.BaseEventState baseEventState, List<String> pool, EncodeAction action, PartitionKey key) {
        BasketballStats statsOne = null;
        BasketballStats statsTwo = null;
        int duration = 0;
        boolean timeOut = false;
        BasketballSegment segment = null;
        int bookPriority = 0;
        statsOne = new BasketballStats(baseEventState.getParticipantStats(0).getScoresList());
        statsTwo = new BasketballStats(baseEventState.getParticipantStats(1).getScoresList());
        duration = baseEventState.getDuration();
        Basketball.BasketballEventState bbEventState = baseEventState.getBasketballEventState();
        timeOut = bbEventState.getTimeout();
        segment = BasketballSegment.valueOf((String)bbEventState.getSegment().name());
        bookPriority = baseEventState.getBasketballEventState().getBookPriority();
        BasketballEventState basketballEventState = new BasketballEventState((IParticipantStats)statsOne, (IParticipantStats)statsTwo, duration, key, matchId, eventId, segment, timeOut, bookPriority);
        return basketballEventState;
    }

    @Override
    public Sports.TimeType encodeTimeType(TimeType timeType) {
        Sports.TimeType.Builder timeTypeBuilder = Sports.TimeType.newBuilder();
        Basketball.BasketballTimeType.Builder bbTimeTypeBuilder = Basketball.BasketballTimeType.newBuilder();
        BasketballTimeType bbTimeType = (BasketballTimeType)timeType;
        bbTimeTypeBuilder.setSettle(Basketball.BasketballTimeType.SettleOn.valueOf(bbTimeType.name()));
        timeTypeBuilder.setBasketballTimeType(bbTimeTypeBuilder);
        return timeTypeBuilder.build();
    }

    @Override
    public TimeType decodeTimeType(Sports.TimeType timeType) {
        BasketballTimeType bbTimeType = BasketballTimeType.valueOf((String)timeType.getBasketballTimeType().getSettle().name());
        return bbTimeType;
    }
}

