/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.protobuf.Sports;
import jayeson.lib.sports.util.PbufToApiConverter;

@Singleton
class CodecHelper {
    CodecHelper() {
    }

    public <K, V> BiMap<K, V> getMap(K[] keys, V[] values) {
        HashBiMap map = HashBiMap.create();
        IntStream.range(0, keys.length).boxed().forEach(arg_0 -> CodecHelper.lambda$getMap$0((BiMap)map, keys, values, arg_0));
        return map;
    }

    public boolean verifyKey(IBetMatch in, PartitionKey key) {
        return in.meta() != null && key != null && PbufToApiConverter.containsKey((String)in.meta().get("AGGREGATE_KEY"), key.toString());
    }

    public boolean verifyKey(IBetEventState in, PartitionKey key) {
        return key != null && key.equals((Object)in.partitionKey());
    }

    public boolean verifyKey(IBetEvent event, PartitionKey key) {
        if (key == null) {
            return false;
        }
        for (IBetEventState state : event.eventStates()) {
            if (!key.equals((Object)state.partitionKey())) continue;
            return true;
        }
        return false;
    }

    public boolean verifyKey(IBetRecord in, PartitionKey key) {
        if (in.source() == null || in.oddType() == null || key == null) {
            return false;
        }
        return in.source().equals(key.source()) && in.oddType().equals((Object)key.oddType());
    }

    public Sports.BaseMatch.Builder getBasketballMatchBuilder(IBetMatch in, StringPool pool) {
        return this.getBaseMatchBuilder(in, pool, Sports.SportType.BASKETBALL);
    }

    public Sports.BaseMatch.Builder getSoccerMatchBuilder(IBetMatch in, StringPool pool) {
        return this.getBaseMatchBuilder(in, pool, Sports.SportType.SOCCER);
    }

    public Sports.BaseMatch.Builder getTennisMatchBuilder(IBetMatch in, StringPool pool) {
        return this.getBaseMatchBuilder(in, pool, Sports.SportType.TENNIS);
    }

    private Sports.BaseMatch.Builder getBaseMatchBuilder(IBetMatch in, StringPool pool, Sports.SportType sportType) {
        Sports.BaseMatch.Builder baseMatchBuilder = Sports.BaseMatch.newBuilder();
        baseMatchBuilder.setId(pool.getIndexOf(in.id()));
        baseMatchBuilder.setLeague(pool.getIndexOf(in.league()));
        baseMatchBuilder.setStartTime(in.startTime());
        if (in.getCountry() != null) {
            baseMatchBuilder.setCountry(pool.getIndexOf(in.getCountry()));
        }
        if (in.meta() != null) {
            Map<String, String> filteredMeta = in.meta().entrySet().stream().filter(e -> !((String)e.getKey()).equals("AGGREGATE_KEY")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
            baseMatchBuilder.putAllMetaInfo(filteredMeta);
        }
        List parts = in.participants();
        baseMatchBuilder.addAllParticipants(parts.stream().map(name -> pool.getIndexOf((String)name)).collect(Collectors.toList()));
        return baseMatchBuilder;
    }

    public Sports.BaseEvent.Builder getBasketballEventBuilder(IBetEvent in, StringPool pool) {
        return this.getBaseEventBuilder(in, pool, Sports.SportType.BASKETBALL);
    }

    public Sports.BaseEvent.Builder getSoccerEventBuilder(IBetEvent in, StringPool pool) {
        return this.getBaseEventBuilder(in, pool, Sports.SportType.SOCCER);
    }

    public Sports.BaseEvent.Builder getTennisEventBuilder(IBetEvent in, StringPool pool) {
        return this.getBaseEventBuilder(in, pool, Sports.SportType.TENNIS);
    }

    private Sports.BaseEvent.Builder getBaseEventBuilder(IBetEvent in, StringPool pool, Sports.SportType sportType) {
        Sports.BaseEvent.Builder baseEventBuilder = Sports.BaseEvent.newBuilder();
        baseEventBuilder.setId(pool.getIndexOf(in.id()));
        baseEventBuilder.setMatchId(pool.getIndexOf(in.matchId()));
        if (in.meta() != null) {
            Map<String, String> filteredMeta = in.meta().entrySet().stream().filter(e -> !((String)e.getKey()).equals("AGGREGATE_KEY")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
            baseEventBuilder.putAllMetaInfo(filteredMeta);
        }
        return baseEventBuilder;
    }

    public Sports.BaseRecord.Builder getBaseRecordBuilder(IBetRecord in, StringPool pool, boolean excludeRateIds) {
        Sports.BaseRecord.Builder baseRecordBuilder = Sports.BaseRecord.newBuilder();
        baseRecordBuilder.setId(in.id());
        baseRecordBuilder.setMatchId(pool.getIndexOf(in.matchId()));
        baseRecordBuilder.setEventId(pool.getIndexOf(in.eventId()));
        baseRecordBuilder.setSource(pool.getIndexOf(in.source()));
        baseRecordBuilder.setOddType(Sports.OddType.valueOf(in.oddType().name()));
        if (in.meta() != null) {
            baseRecordBuilder.putAllMetaInfo(in.meta());
        }
        baseRecordBuilder.setFormat(Sports.OddFormat.valueOf(in.oddFormat().name()));
        baseRecordBuilder.addAllRates(in.rates());
        if (!excludeRateIds) {
            List rateIds = in.rateIds();
            baseRecordBuilder.addAllRateIds(rateIds.stream().filter(x -> x != null).map(x -> pool.getIndexOf((String)x)).collect(Collectors.toList()));
        }
        baseRecordBuilder.setLbType(Sports.LBType.valueOf(in.lbType().name()));
        if (in instanceof IB2Record) {
            IB2Record b2Record = (IB2Record)in;
            baseRecordBuilder.setPivotValue(b2Record.pivotValue());
            baseRecordBuilder.setPivotType(Sports.PivotType.valueOf(b2Record.pivotType().name()));
            baseRecordBuilder.setPivotBias(Sports.PivotBias.valueOf(b2Record.pivotBias().name()));
        }
        return baseRecordBuilder;
    }

    public Sports.BaseEventState.Builder getBaseEventStateBuilder(IBetEventState in, StringPool pool) {
        Sports.BaseEventState.Builder baseEventStateBuilder = Sports.BaseEventState.newBuilder();
        baseEventStateBuilder.setDuration(in.duration());
        List stats = in.stats();
        stats.stream().forEach(stat -> baseEventStateBuilder.addParticipantStats(Sports.Stats.newBuilder().addAllScores(stat.getScores())));
        return baseEventStateBuilder;
    }

    public static Map<String, String> populatePKIntoMetaInfo(Map<String, String> meta, PartitionKey key) {
        if (meta == null) {
            meta = new HashMap<String, String>();
        }
        meta.put("AGGREGATE_KEY", key.toString());
        return meta;
    }

    private static /* synthetic */ void lambda$getMap$0(BiMap map, Object[] keys, Object[] values, Integer i) {
        map.put(keys[i], values[i]);
    }
}

