/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.codec.DeleteEventMessageClass;
import jayeson.lib.sports.codec.DeleteMatchMessageClass;
import jayeson.lib.sports.codec.InsertEventMessageClass;
import jayeson.lib.sports.codec.InsertMatchMessageClass;
import jayeson.lib.sports.codec.UpdateEventMessageClass;
import jayeson.lib.sports.core.Delta;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.ConvertedMsg;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.MessageBeforeTransform;
import jayeson.lib.sports.datastructure.TTLWrapper;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;

public class ClientDeltaTransformingLogicImpl
implements DeltaTransformingLogic {
    private IndexedSnapshot combineSs;
    private IndexedSnapshot beforeSnap;

    @Override
    public Collection<Incoming> transform(SportsFeedMessageGroup sportsGrp, String stream, IMessageClass<?> msgType, IndexedSnapshot delta, MessageBeforeTransform msgBefore) {
        if (msgType instanceof InsertEventMessageClass) {
            return this.suppressInsertEvent(msgBefore, sportsGrp, msgType, stream, delta, new ArrayList<Incoming>());
        }
        if (msgType instanceof DeleteEventMessageClass) {
            return this.suppressDeleteEvent(msgBefore, sportsGrp, msgType, stream, delta, new ArrayList<Incoming>());
        }
        if (msgType instanceof UpdateEventMessageClass) {
            return ClientDeltaTransformingLogicImpl.combineEventState(msgBefore, sportsGrp, msgType, stream, delta, new ArrayList<Incoming>());
        }
        if (msgType instanceof InsertMatchMessageClass) {
            return this.suppressInsertMatch(msgBefore, sportsGrp, msgType, stream, delta, new ArrayList<Incoming>());
        }
        if (msgType instanceof DeleteMatchMessageClass) {
            return this.suppressDeleteMatch(msgBefore, sportsGrp, msgType, stream, delta, new ArrayList<Incoming>());
        }
        ArrayList<Incoming> msg = new ArrayList<Incoming>();
        msg.add(new Incoming(msgType, stream, delta));
        return msg;
    }

    @Override
    public MergeableWrapper transformTTLRestore(Collection<TTLWrapper> ttlRestoredList, SportsFeedMessageGroup grp, String stream, IndexedSnapshot before, IndexedSnapshot after, Map<PartitionKey, Long> restoredKeys) {
        this.combineSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        MergeableWrapper wrap = new MergeableWrapper();
        ttlRestoredList.stream().forEach(ttlWrapper -> {
            IndexedSnapshot ssRestored = ttlWrapper.getRestoredSs();
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_MATCH, ssRestored, this.combineSs).getAfterSs();
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_EVENT, ssRestored, this.combineSs).getAfterSs();
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_ODD, ssRestored, this.combineSs).getAfterSs();
        });
        Collection<Incoming> breakdownCol = ClientDeltaTransformingLogicImpl.breakdownTTL(grp, stream, new IndexedSnapshotImpl(this.combineSs.matches(), restoredKeys));
        this.beforeSnap = before;
        ArrayList<DeltaOutgoing> outgoCol = new ArrayList<DeltaOutgoing>();
        breakdownCol.stream().forEach(i -> {
            MessageBeforeTransform msgBefore = SnapshotUtil.combineSnapshots(i.msgType(), i.data(), this.beforeSnap);
            if (i.msgType().isSameFormat((IMessageClass)grp.DATA_INSERT_MATCH) || i.msgType().isSameFormat((IMessageClass)grp.DATA_INSERT_EVENT)) {
                Collection<Incoming> incomeCol = this.transform(grp, stream, i.msgType(), i.data(), msgBefore);
                incomeCol.stream().forEach(incomingAfterTransform -> {
                    Delta iDelta = !incomingAfterTransform.getConverted().equals((Object)ConvertedMsg.ORIGINAL) ? new Delta((Incoming)incomingAfterTransform, msgBefore.getAfterSs(), this.beforeSnap, incomingAfterTransform.getConverted()) : new Delta((Incoming)incomingAfterTransform, msgBefore.getAfterSs(), this.beforeSnap);
                    outgoCol.add(iDelta);
                    this.beforeSnap = msgBefore.getAfterSs();
                });
            } else {
                Delta iDelta = new Delta((Incoming)i, msgBefore.getAfterSs(), before);
                outgoCol.add(iDelta);
            }
        });
        wrap.setAfter(after);
        wrap.setDeltaOut(outgoCol);
        return wrap;
    }

    @Override
    public MergeableWrapper transformTTLRemove(Collection<IndexedSnapshot> ttlRemoveList, SportsFeedMessageGroup grp, String stream, IndexedSnapshot before, IndexedSnapshot after, Map<PartitionKey, Long> keysRemoved) {
        MergeableWrapper wrapper = new MergeableWrapper();
        this.combineSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        ttlRemoveList.stream().forEach(ssRemoved -> {
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_MATCH, ssRemoved, this.combineSs).getAfterSs();
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_EVENT, ssRemoved, this.combineSs).getAfterSs();
            this.combineSs = SnapshotUtil.combineSnapshots(grp.DATA_INSERT_ODD, ssRemoved, this.combineSs).getAfterSs();
        });
        Collection<Incoming> breakdownResetCol = ClientDeltaTransformingLogicImpl.breakdownReset(grp, stream, this.combineSs);
        this.beforeSnap = before;
        ArrayList<DeltaOutgoing> outgoCol = new ArrayList<DeltaOutgoing>();
        breakdownResetCol.stream().forEach(i -> {
            MessageBeforeTransform msgBefore = SnapshotUtil.combineSnapshots(i.msgType(), i.data(), this.beforeSnap);
            if (i.msgType().isSameFormat((IMessageClass)grp.DATA_DELETE_MATCH) || i.msgType().isSameFormat((IMessageClass)grp.DATA_DELETE_EVENT)) {
                Collection<Incoming> incomeCol = this.transform(grp, stream, i.msgType(), i.data(), msgBefore);
                incomeCol.stream().forEach(incomingAfterTransform -> {
                    Delta iDelta = !incomingAfterTransform.getConverted().equals((Object)ConvertedMsg.ORIGINAL) ? new Delta((Incoming)incomingAfterTransform, msgBefore.getAfterSs(), this.beforeSnap, incomingAfterTransform.getConverted()) : new Delta((Incoming)incomingAfterTransform, msgBefore.getAfterSs(), this.beforeSnap);
                    outgoCol.add(iDelta);
                    this.beforeSnap = msgBefore.getAfterSs();
                });
            } else {
                Delta iDelta = new Delta((Incoming)i, msgBefore.getAfterSs(), before);
                outgoCol.add(iDelta);
            }
        });
        wrapper.setDeltaOut(outgoCol);
        wrapper.setAfter(after);
        return wrapper;
    }

    public static Collection<Incoming> breakdownReset(SportsFeedMessageGroup grp, String stream, IndexedSnapshot removeSs) {
        IndexedSnapshot noEventSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        IndexedSnapshot noRecordSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        IIndexedSnapshotBuilder iMatchBuilder = BuilderProvider.getSnapshotBuilder(removeSs);
        IIndexedSnapshotBuilder iEventBuilder = BuilderProvider.getSnapshotBuilder(removeSs);
        for (IBetMatch m : removeSs.matches()) {
            IBetMatchBuilder noEventMatchBuilder = BuilderProvider.getBuilder(m);
            IBetMatchBuilder noRecordEventBuilder = BuilderProvider.getBuilder(m);
            for (IBetEvent e : m.events()) {
                noEventMatchBuilder.deleteChild(e);
                IBetEventBuilder noRecord = BuilderProvider.getBuilder(e);
                for (IBetRecord r : e.records()) {
                    noRecord.deleteChild(r);
                }
                noRecordEventBuilder.replaceEvent((IBetEvent)noRecord.build());
            }
            iMatchBuilder.replaceMatch((IBetMatch)noEventMatchBuilder.build());
            iEventBuilder.replaceMatch((IBetMatch)noRecordEventBuilder.build());
        }
        noEventSs = (IndexedSnapshot)iMatchBuilder.build();
        noRecordSs = (IndexedSnapshot)iEventBuilder.build();
        ArrayList<Incoming> matchMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_DELETE_MATCH, stream, noEventSs)));
        ArrayList<Incoming> evtMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_DELETE_EVENT, stream, noRecordSs)));
        ArrayList<Incoming> oddMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_DELETE_ODD, stream, removeSs)));
        oddMsg.addAll(evtMsg);
        oddMsg.addAll(matchMsg);
        return oddMsg;
    }

    public static Collection<Incoming> breakdownTTL(SportsFeedMessageGroup grp, String stream, IndexedSnapshot restoredSS) {
        IndexedSnapshot noEventSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        IndexedSnapshot noRecordSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        IIndexedSnapshotBuilder iMatchBuilder = BuilderProvider.getSnapshotBuilder(restoredSS);
        IIndexedSnapshotBuilder iEventBuilder = BuilderProvider.getSnapshotBuilder(restoredSS);
        for (IBetMatch m : restoredSS.matches()) {
            IBetMatchBuilder noEventMatchBuilder = BuilderProvider.getBuilder(m);
            IBetMatchBuilder noRecordEventBuilder = BuilderProvider.getBuilder(m);
            for (IBetEvent e : m.events()) {
                noEventMatchBuilder.deleteChild(e);
                IBetEventBuilder noRecord = BuilderProvider.getBuilder(e);
                for (IBetRecord r : e.records()) {
                    noRecord.deleteChild(r);
                }
                noRecordEventBuilder.replaceEvent((IBetEvent)noRecord.build());
            }
            iMatchBuilder.replaceMatch((IBetMatch)noEventMatchBuilder.build());
            iEventBuilder.replaceMatch((IBetMatch)noRecordEventBuilder.build());
        }
        noEventSs = (IndexedSnapshot)iMatchBuilder.build();
        noRecordSs = (IndexedSnapshot)iEventBuilder.build();
        ArrayList<Incoming> matchMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_INSERT_MATCH, stream, noEventSs)));
        ArrayList<Incoming> evtMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_INSERT_EVENT, stream, noRecordSs)));
        ArrayList<Incoming> oddMsg = new ArrayList<Incoming>(Arrays.asList(new Incoming((IMessageClass<?>)grp.DATA_INSERT_ODD, stream, restoredSS)));
        matchMsg.addAll(evtMsg);
        matchMsg.addAll(oddMsg);
        return matchMsg;
    }

    public static Collection<Incoming> combineEventState(MessageBeforeTransform msgBefore, SportsFeedMessageGroup sportsGrp, IMessageClass<?> msgType, String stream, IndexedSnapshot delta, ArrayList<Incoming> msg) {
        IIndexedSnapshotBuilder updateEventSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        delta.matches().stream().forEach(m -> {
            IBetMatchBuilder updateMatchBuilder = BuilderProvider.getBuilder(m);
            m.events().stream().forEach(e -> {
                IBetEventBuilder updateEventBuilder = BuilderProvider.getBuilder(e);
                updateEventBuilder.aggregateInsert(msgBefore.getAfterSs().match(m.id()).event(e.id()));
                updateMatchBuilder.replaceEvent((IBetEvent)updateEventBuilder.build());
            });
            updateEventSnapshotBuilder.replaceMatch((IBetMatch)updateMatchBuilder.build());
        });
        msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_UPDATE_EVENT, stream, (IndexedSnapshot)updateEventSnapshotBuilder.build()));
        return msg;
    }

    @Override
    public Collection<Incoming> suppressDeleteEvent(MessageBeforeTransform msgBefore, SportsFeedMessageGroup sportsGrp, IMessageClass<?> msgType, String stream, IndexedSnapshot delta, ArrayList<Incoming> msg) {
        IIndexedSnapshotBuilder deleteEventSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        IIndexedSnapshotBuilder updateEventSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        if (!msgBefore.getDeleteEvent().isEmpty()) {
            HashMap suppressedMatches = new HashMap();
            msgBefore.getTransformEvent().stream().forEach(id -> {
                String matchId = id.getMatchId();
                IBetMatch match = msgBefore.getBeforeSs().match(matchId);
                IBetMatchBuilder suppressedMatchBuilder = suppressedMatches.getOrDefault(matchId, BuilderProvider.getBuilder(match));
                suppressedMatchBuilder.deleteChild(match.event(id.getEventId()));
                suppressedMatches.put(matchId, suppressedMatchBuilder);
            });
            suppressedMatches.values().stream().forEach(matchBuilder -> deleteEventSnapshotBuilder.replaceMatch((IBetMatch)matchBuilder.build()));
            msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_DELETE_EVENT, stream, (IndexedSnapshot)deleteEventSnapshotBuilder.build()));
        }
        if (!msgBefore.getTransformEvent().isEmpty()) {
            HashMap deletedMatches = new HashMap();
            msgBefore.getDeleteEvent().stream().forEach(id -> {
                String matchId = id.getMatchId();
                IBetMatch match = msgBefore.getBeforeSs().match(matchId);
                IBetMatchBuilder updatedMatchBuilder = deletedMatches.getOrDefault(matchId, BuilderProvider.getBuilder(match));
                updatedMatchBuilder.deleteChild(match.event(id.getEventId()));
                deletedMatches.put(matchId, updatedMatchBuilder);
            });
            deletedMatches.values().stream().forEach(deletedMatchBuilder -> updateEventSnapshotBuilder.replaceMatch((IBetMatch)deletedMatchBuilder.build()));
            HashMap updatedMatches = new HashMap();
            msgBefore.getTransformEvent().stream().forEach(id -> {
                String matchId = id.getMatchId();
                String eventId = id.getEventId();
                IBetMatchBuilder updateMatchBuilder = updatedMatches.getOrDefault(matchId, BuilderProvider.getBuilder(msgBefore.getAfterSs().match(matchId)));
                IBetEventBuilder updateEventBuilder = BuilderProvider.getBuilder(msgBefore.getBeforeSs().match(matchId).event(eventId));
                updateEventBuilder.aggregateDelete(delta.match(matchId).event(eventId));
                updateMatchBuilder.replaceEvent((IBetEvent)updateEventBuilder.build());
                updatedMatches.put(matchId, updateMatchBuilder);
            });
            updatedMatches.values().stream().forEach(updateMatchBuilder -> updateEventSnapshotBuilder.replaceMatch((IBetMatch)updateMatchBuilder.build()));
            msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_UPDATE_EVENT, stream, (IndexedSnapshot)updateEventSnapshotBuilder.build(), ConvertedMsg.DELETE_EVENT_TO_UPDATE));
        }
        return msg;
    }

    @Override
    public Collection<Incoming> suppressInsertEvent(MessageBeforeTransform msgBefore, SportsFeedMessageGroup sportsGrp, IMessageClass<?> msgType, String stream, IndexedSnapshot delta, ArrayList<Incoming> msg) {
        IIndexedSnapshotBuilder insertEventSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        IIndexedSnapshotBuilder updateEventSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        if (delta.matches().size() != 0) {
            if (!msgBefore.getInsertEvent().isEmpty()) {
                HashMap updatedEvents = new HashMap();
                msgBefore.getTransformEvent().stream().forEach(id -> {
                    String matchId = id.getMatchId();
                    IBetMatch match = delta.match(matchId);
                    IBetMatchBuilder insertMatchBuilder = updatedEvents.getOrDefault(matchId, BuilderProvider.getBuilder(match));
                    insertMatchBuilder.deleteChild(match.event(id.getEventId()));
                    updatedEvents.put(matchId, insertMatchBuilder);
                });
                updatedEvents.values().stream().forEach(insertEventBuilder -> insertEventSnapshotBuilder.replaceMatch((IBetMatch)insertEventBuilder.build()));
                msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_INSERT_EVENT, stream, (IndexedSnapshot)insertEventSnapshotBuilder.build()));
            }
            if (!msgBefore.getTransformEvent().isEmpty()) {
                HashMap insertedEvents = new HashMap();
                msgBefore.getInsertEvent().stream().forEach(id -> {
                    String matchId = id.getMatchId();
                    IBetMatch match = delta.match(matchId);
                    IBetMatchBuilder insertMatchBuilder = insertedEvents.getOrDefault(matchId, BuilderProvider.getBuilder(match));
                    insertMatchBuilder.deleteChild(match.event(id.getEventId()));
                    insertedEvents.put(matchId, insertMatchBuilder);
                });
                insertedEvents.values().stream().forEach(updateEventBuilder -> updateEventSnapshotBuilder.replaceMatch((IBetMatch)updateEventBuilder.build()));
                HashMap updatedEvents = new HashMap();
                msgBefore.getTransformEvent().stream().forEach(id -> {
                    String matchId = id.getMatchId();
                    String eventId = id.getEventId();
                    IBetMatch match = delta.match(matchId);
                    IBetMatchBuilder insertMatchBuilder = updatedEvents.getOrDefault(matchId, BuilderProvider.getBuilder(match));
                    IBetEventBuilder insertEventBuilder = BuilderProvider.getBuilder(match.event(eventId));
                    insertEventBuilder.aggregateInsert(msgBefore.getAfterSs().match(matchId).event(eventId));
                    insertMatchBuilder.replaceEvent((IBetEvent)insertEventBuilder.build());
                    updatedEvents.put(matchId, insertMatchBuilder);
                });
                updatedEvents.values().forEach(insertMatchBuilder -> updateEventSnapshotBuilder.replaceMatch((IBetMatch)insertMatchBuilder.build()));
                msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_UPDATE_EVENT, stream, (IndexedSnapshot)updateEventSnapshotBuilder.build(), ConvertedMsg.INSERT_EVENT_TO_UPDATE));
            }
        }
        return msg;
    }

    @Override
    public Collection<Incoming> suppressDeleteMatch(MessageBeforeTransform msgBefore, SportsFeedMessageGroup sportsGrp, IMessageClass<?> msgType, String stream, IndexedSnapshot delta, ArrayList<Incoming> msg) {
        IIndexedSnapshotBuilder deleteMatchSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        IIndexedSnapshotBuilder updateMatchSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        if (!msgBefore.getSuppressMatch().isEmpty()) {
            msgBefore.getSuppressMatch().stream().forEach(id -> {
                IBetMatchBuilder suppressMatchBuilder = BuilderProvider.getBuilder(delta.match(id.split("_")[0]));
                deleteMatchSnapshotBuilder.deleteChild(suppressMatchBuilder.build());
            });
        }
        if (!msgBefore.getDeleteMatch().isEmpty()) {
            msgBefore.getDeleteMatch().stream().forEach(id -> {
                IBetMatchBuilder suppressMatchBuilder = BuilderProvider.getBuilder(delta.match(id.split("_")[0]));
                updateMatchSnapshotBuilder.deleteChild(suppressMatchBuilder.build());
            });
        }
        if (!((IndexedSnapshot)deleteMatchSnapshotBuilder.build()).matches().isEmpty()) {
            msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_DELETE_MATCH, stream, (IndexedSnapshot)deleteMatchSnapshotBuilder.build()));
        }
        return msg;
    }

    @Override
    public Collection<Incoming> suppressInsertMatch(MessageBeforeTransform msgBefore, SportsFeedMessageGroup sportsGrp, IMessageClass<?> msgType, String stream, IndexedSnapshot delta, ArrayList<Incoming> msg) {
        IIndexedSnapshotBuilder insertMatchSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        IIndexedSnapshotBuilder updateMatchSnapshotBuilder = BuilderProvider.getSnapshotBuilder(delta);
        if (!msgBefore.getSuppressMatch().isEmpty()) {
            msgBefore.getSuppressMatch().stream().forEach(id -> {
                IBetMatchBuilder suppressMatchBuilder = BuilderProvider.getBuilder(delta.match(id.split("_")[0]));
                insertMatchSnapshotBuilder.deleteChild(suppressMatchBuilder.build());
            });
        }
        if (!msgBefore.getInsertMatch().isEmpty()) {
            msgBefore.getInsertMatch().stream().forEach(id -> {
                IBetMatchBuilder suppressMatchBuilder = BuilderProvider.getBuilder(delta.match(id.split("_")[0]));
                updateMatchSnapshotBuilder.deleteChild(suppressMatchBuilder.build());
            });
        }
        if (!((IndexedSnapshot)insertMatchSnapshotBuilder.build()).matches().isEmpty()) {
            msg.add(new Incoming((IMessageClass<?>)sportsGrp.DATA_INSERT_MATCH, stream, (IndexedSnapshot)insertMatchSnapshotBuilder.build()));
        }
        return msg;
    }
}

