/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jayeson.lib.sports.dispatch.FilterListenerImpl;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.OutFactory;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPGCache
implements IFilterEventListener {
    private static Logger log = LoggerFactory.getLogger(EPGCache.class);
    private Map<IDataFilter, IEndPointGroup> cachedTEPGs;
    private IEndPointGroup relayEPG;
    private OutFactory.EPGFactory epgFactory;
    private FilterListenerImpl filterListener;
    private StreamCommandProcessor scp;

    @Inject
    public EPGCache(OutFactory.EPGFactory epgFactory, FilterListenerImpl filterListener, StreamCommandProcessor scp) {
        this.epgFactory = epgFactory;
        this.filterListener = filterListener;
        filterListener.setEpgCache(this);
        this.scp = scp;
        this.relayEPG = epgFactory.createREPG();
        this.cachedTEPGs = new ConcurrentHashMap<IDataFilter, IEndPointGroup>();
        this.scp.registerEPG(this.relayEPG);
    }

    public synchronized IEndPointGroup createEPG(IDataFilter filter, String stream) {
        IEndPointGroup tepg;
        IEndPointGroup prev;
        if (filter == null) {
            return this.relayEPG;
        }
        IEndPointGroup epg = this.cachedTEPGs.get(filter);
        if (epg == null && (prev = this.cachedTEPGs.putIfAbsent(filter, tepg = this.epgFactory.createTEPG())) == null) {
            this.filterListener.setupFilter(tepg, filter);
            this.scp.registerEPG(tepg);
        }
        this.cachedTEPGs.get(filter).createEPGCP(stream);
        this.printStat();
        return this.cachedTEPGs.get(filter);
    }

    public void destroyEPG(IEndPointGroup epg) {
        if (epg == this.relayEPG) {
            return;
        }
        if (epg.isEmpty()) {
            this.filterListener.teardownFilter(epg);
            this.removeFromCache(epg.getFilter());
            this.scp.deregisterEPG(epg);
            epg.cleanUp();
        }
        log.debug("Destroying epg for filter: {}", (Object)epg.getFilter());
        this.printStat();
    }

    void addToCache(IEndPointGroup epg) {
        this.cachedTEPGs.put(epg.getFilter(), epg);
    }

    IEndPointGroup removeFromCache(IDataFilter filter) {
        return this.cachedTEPGs.remove(filter);
    }

    public IEndPointGroup getEPG(IDataFilter filter) {
        return this.cachedTEPGs.get(filter);
    }

    public IEndPointGroup getEPG(IEndPointDispatcher epd) {
        Collection<IEndPointGroup> epgs = this.getEPGs(epd);
        if (epgs.isEmpty()) {
            return null;
        }
        return epgs.iterator().next();
    }

    public Collection<IEndPointGroup> getEPGs(IEndPointDispatcher epd) {
        ArrayList<IEndPointGroup> epgs = new ArrayList<IEndPointGroup>();
        if (this.relayEPG.hasEPD(epd.getStream(), epd.id())) {
            epgs.add(this.relayEPG);
        }
        for (IEndPointGroup epg : this.cachedTEPGs.values()) {
            if (!epg.hasEPD(epd.getStream(), epd.id())) continue;
            epgs.add(epg);
        }
        return epgs;
    }

    public IEndPointGroup getRelayEPG() {
        return this.relayEPG;
    }

    public FilterListenerImpl getFilterListenerImpl() {
        return this.filterListener;
    }

    public void printStat() {
        log.debug("TEPG Count: {}", (Object)this.cachedTEPGs.size());
    }
}

