/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;

public class FullSnapshotWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private IEndPointDispatcher epd;
    private IndexedSnapshot fullSnapshot;

    public FullSnapshotWrapper(IEndPointGroup epg, String stream, IEndPointDispatcher epd, IndexedSnapshot fullSnapshot) {
        super(epg, stream);
        this.epd = epd;
        this.fullSnapshot = fullSnapshot;
    }

    @Override
    public Consumer<Void> postProcess() {
        return Void2 -> {
            Collection<Outgoing> mwList = this.getEpg().generate(this);
            if (mwList != null) {
                for (Outgoing mw : mwList) {
                    this.epd.submitToDispatchingQueue(mw);
                }
                this.epd.submitEndQueueIndicatorToDispatchingQueue(false);
            }
            this.getEpg().setInitialized(true);
        };
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            this.getEpd().readyToDispatch();
            this.getEpg().submitForPostProcess(this);
        };
    }

    public IndexedSnapshot getFullSnapshot() {
        return this.fullSnapshot;
    }

    public IEndPointDispatcher getEpd() {
        return this.epd;
    }

    public void setFullSnapshot(IndexedSnapshot fullSnapshot) {
        this.fullSnapshot = fullSnapshot;
    }
}

