/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.filter;

import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.ConvertedMsg;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.filter.FilterContext;
import jayeson.lib.sports.filter.FilterableIndexSnapshot;
import jayeson.lib.sports.filter.MessageFilter;
import jayeson.model.IDataFilter;

public class FilterableOutgoing
implements DeltaOutgoing {
    private DeltaOutgoing original;
    private MessageFilter filter;
    private FilterableIndexSnapshot delta;
    private FilterableIndexSnapshot before;
    private FilterableIndexSnapshot after;

    public FilterableOutgoing(DeltaOutgoing original, IDataFilter filter) {
        FilterContext context = new FilterContext(original, (SportsFeedMessageGroup)original.msgType().group());
        this.original = original;
        this.filter = new MessageFilter(filter, context);
        this.delta = new FilterableIndexSnapshot(original.delta(), this.filter);
        this.before = new FilterableIndexSnapshot(original.before(), this.filter);
        this.after = new FilterableIndexSnapshot(original.after(), this.filter);
    }

    @Override
    public IMessageClass<?> msgType() {
        return this.original.msgType();
    }

    @Override
    public IndexedSnapshot after() {
        return this.after;
    }

    @Override
    public IndexedSnapshot delta() {
        return this.delta;
    }

    @Override
    public IndexedSnapshot before() {
        return this.before;
    }

    public DeltaOutgoing getOriginal() {
        return this.original;
    }

    public IDataFilter getFilter() {
        return this.filter;
    }

    @Override
    public ConvertedMsg getConverted() {
        return this.getConverted();
    }
}

