/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.filter;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.filter.FilterContext;
import jayeson.model.IDataFilter;
import jayeson.model.IDataFilterRule;

class MessageFilter
implements IDataFilter {
    private static final long serialVersionUID = 9160440090583156550L;
    private final IDataFilter filter;
    private final FilterContext context;

    public MessageFilter(IDataFilter filter, FilterContext context) {
        this.filter = filter;
        this.context = context;
    }

    public boolean isPassed(IBetMatch match, ISnapshot<?> snapshot) {
        IBetMatch input = this.context.getMatch(match.id());
        if (input == null) {
            return false;
        }
        ISnapshot<?> comparedSS = this.getRelevantSnapshot(this.context);
        return this.filter.isPassed(input, comparedSS);
    }

    public boolean isPassed(IBetEvent event, ISnapshot<?> snapshot) {
        IBetEvent input = this.context.getEvent(event.matchId(), event.id());
        if (input == null) {
            return false;
        }
        ISnapshot<?> comparedSS = this.getRelevantSnapshot(this.context);
        return this.filter.isPassed(input, comparedSS);
    }

    public boolean isPassed(IBetRecord record, ISnapshot<?> snapshot) {
        IBetRecord input = this.context.getRecord(record.matchId(), record.eventId(), record.source(), record.id());
        ISnapshot<?> comparedSS = this.getRelevantSnapshot(this.context);
        return this.filter.isPassed(input, comparedSS);
    }

    private ISnapshot<?> getRelevantSnapshot(FilterContext context) {
        if (this.isDeleteMsgType(context.getDelta().msgType())) {
            return context.getDelta().before();
        }
        return context.getDelta().after();
    }

    private boolean isDeleteMsgType(IMessageClass<?> msgType) {
        SportsFeedMessageGroup msgGroup = (SportsFeedMessageGroup)msgType.group();
        return msgType == msgGroup.DATA_DELETE_MATCH || msgType == msgGroup.DATA_DELETE_EVENT || msgType == msgGroup.DATA_DELETE_ODD;
    }

    public int compareTo(IDataFilter o) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public Collection<IDataFilterRule> getFilterRules() {
        return this.filter.getFilterRules();
    }

    public void setFilterRules(Collection<IDataFilterRule> filterRules) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void addFilterRule(IDataFilterRule rule) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void removeFilterRule(IDataFilterRule rule) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public boolean isRunnable() {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void setExecutor(ScheduledExecutorService se) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void startAllRunnableRules() {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void stopAllRunnableRules() {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void addFilterRule(IDataFilterRule rule, boolean canListenToRule) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void replaceFilterRule(IDataFilterRule rule, boolean canListenToRule) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }

    public void setFilterRules(Collection<IDataFilterRule> filterRules, boolean canListenToRule) {
        throw new UnsupportedOperationException("Not supported in this implementation");
    }
}

