/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.api.twoside.IB2Match;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.util.PbufToApiConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class B2MatchBuilder
implements IBetMatchBuilder {
    private static Logger log = LoggerFactory.getLogger(B2MatchBuilder.class);
    protected long startTime;
    protected Map<String, IBetEvent> events = new HashMap<String, IBetEvent>();
    protected String id;
    protected String league;
    protected SportType sport;
    protected Map<String, String> meta;
    protected String p1;
    protected String p2;

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLeague(String league) {
        this.league = league;
    }

    public void setSport(SportType sport) {
        this.sport = sport;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public void setP1(String p1) {
        this.p1 = p1;
    }

    public void setP2(String p2) {
        this.p2 = p2;
    }

    public void mergeFrom(IBetMatch match, boolean cloneChildren) {
        if (!(match instanceof IB2Match)) {
            throw new IllegalArgumentException("Expected IB2Match for B2MatchBuilder");
        }
        IB2Match t = (IB2Match)match;
        this.startTime = t.startTime();
        if (cloneChildren && t.events() != null) {
            this.events = t.events().stream().collect(Collectors.toMap(IBetEvent::id, Function.identity()));
        }
        this.id = t.id();
        this.league = t.league();
        this.sport = t.sportType();
        this.meta = new HashMap<String, String>(t.meta());
        this.p1 = t.participantOne();
        this.p2 = t.participantTwo();
    }

    public B2MatchBuilder(IBetMatch t, boolean cloneChildren) {
        this.mergeFrom(t, cloneChildren);
    }

    @Override
    public void setPartition(PartitionKey key) {
        this.meta.put("AGGREGATE_KEY", key.toString());
    }

    @Override
    public String insertChild(IBetEvent inputEvent) {
        String suppressMatch = null;
        IBetEvent obj = this.events.get(inputEvent.id());
        if (obj == null) {
            this.events.put(inputEvent.id(), inputEvent);
        } else {
            suppressMatch = inputEvent.id();
            IBetEvent exist = obj;
            IBetEventBuilder builder = BuilderProvider.getBuilder(exist);
            builder.aggregateInsert(inputEvent);
            this.events.put(inputEvent.id(), (IBetEvent)builder.build());
        }
        return suppressMatch;
    }

    @Override
    public void updateChild(IBetEvent updateEvent) {
        IBetEvent obj = this.events.get(updateEvent.id());
        if (obj == null) {
            log.error("[UpdateEvent] Cannot find eventId {} from match {} to execute update event from {}", new Object[]{updateEvent.id(), this.id, updateEvent.meta().get("AGGREGATE_KEY")});
            return;
        }
        IBetEvent existing = obj;
        IBetEventBuilder builder = BuilderProvider.getBuilder(existing);
        builder.aggregateUpdate(updateEvent);
        this.events.put(updateEvent.id(), (IBetEvent)builder.build());
    }

    @Override
    public String deleteChild(IBetEvent inputEvent) {
        String suppressEvent = null;
        IBetEvent obj = this.events.get(inputEvent.id());
        if (obj == null) {
            log.error("[DeleteEvent] Cannot find eventId {} of match {} to execute delete event from {}", new Object[]{inputEvent.id(), this.id, inputEvent.meta().get("AGGREGATE_KEY")});
            return null;
        }
        IBetEvent existing = obj;
        IBetEventBuilder builder = BuilderProvider.getBuilder(existing);
        boolean isEmpty = builder.aggregateDelete(inputEvent);
        if (isEmpty) {
            this.events.remove(inputEvent.id());
        } else {
            suppressEvent = inputEvent.id();
            this.events.put(inputEvent.id(), (IBetEvent)builder.build());
        }
        return suppressEvent;
    }

    @Override
    public void replaceEvent(IBetEvent event) {
        this.events.put(event.id(), event);
    }

    @Override
    public void aggregateInsert(IBetMatch match) {
        for (String s : match.meta().keySet()) {
            if (s.equals("AGGREGATE_KEY")) continue;
            this.meta.put(s, (String)match.meta().get(s));
        }
        this.setStartTime(match.startTime());
        String incoming = (String)match.meta().get("AGGREGATE_KEY");
        String existing = this.meta.get("AGGREGATE_KEY");
        this.meta.put("AGGREGATE_KEY", PbufToApiConverter.addKey(existing, incoming));
    }

    @Override
    public void aggregateUpdate(IBetMatch match) {
        for (String s : match.meta().keySet()) {
            if (s.equals("AGGREGATE_KEY")) continue;
            this.meta.put(s, (String)match.meta().get(s));
        }
        this.setStartTime(match.startTime());
    }

    @Override
    public boolean aggregateDelete(IBetMatch meta) {
        String incoming = (String)meta.meta().get("AGGREGATE_KEY");
        String existing = this.meta.get("AGGREGATE_KEY");
        String removed = PbufToApiConverter.removeKey(existing, incoming);
        this.meta.put("AGGREGATE_KEY", removed);
        return removed.isEmpty();
    }

    @Override
    public IBetMatchBuilder reset(PartitionKey key) {
        String incoming = key.toString();
        String existing = this.meta.get("AGGREGATE_KEY");
        if (!PbufToApiConverter.containsKey(existing, incoming)) {
            return null;
        }
        B2MatchBuilder removedDataMatchBuilder = (B2MatchBuilder)BuilderProvider.getBuilder((IBetMatch)this.build());
        String removed = PbufToApiConverter.removeKey(existing, incoming);
        this.meta.put("AGGREGATE_KEY", removed);
        removedDataMatchBuilder.meta.put("AGGREGATE_KEY", incoming);
        Collection<IBetEvent> eventCol = this.events.values();
        HashMap<String, IBetEvent> updatedEvents = new HashMap<String, IBetEvent>();
        removedDataMatchBuilder.events.clear();
        for (IBetEvent event : eventCol) {
            IBetEventBuilder remainingEventbuilder = BuilderProvider.getBuilder(event);
            IBetEventBuilder removedEventBldr = remainingEventbuilder.reset(key);
            if (removedEventBldr != null && !removedEventBldr.isEmpty()) {
                removedDataMatchBuilder.insertChild((IBetEvent)removedEventBldr.build());
            }
            if (!remainingEventbuilder.isEmpty()) {
                updatedEvents.put(event.id(), (IBetEvent)remainingEventbuilder.build());
                continue;
            }
            updatedEvents.remove(event.id());
        }
        this.events = updatedEvents;
        return removedDataMatchBuilder;
    }

    @Override
    public boolean isEmpty() {
        String existing = this.meta.get("AGGREGATE_KEY");
        return existing == null || existing.isEmpty();
    }

    @Override
    public int size() {
        return this.events.size();
    }
}

