/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class DurationRangeFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private int durationLower = 0;
    private int durationUpper = 0;

    public DurationRangeFilterRule() {
        this.ruleType = 1;
    }

    protected boolean inRange(float lower, float upper, float num) {
        return lower <= num && upper >= num;
    }

    public int getDurationLower() {
        return this.durationLower;
    }

    public int getDurationUpper() {
        return this.durationUpper;
    }

    public void setDurationLower(int durationLower) {
        this.durationLower = durationLower;
    }

    public void setDurationUpper(int durationUpper) {
        this.durationUpper = durationUpper;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        return this.inRange(this.durationLower, this.durationUpper, event.eventState().duration());
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof DurationRangeFilterRule) {
            DurationRangeFilterRule rule = (DurationRangeFilterRule)o;
            if (this.getDurationLower() != rule.getDurationLower()) {
                return -1;
            }
            if (this.getDurationUpper() != rule.getDurationUpper()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + this.durationLower;
        result = 31 * result + this.durationUpper;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

