/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;
import jayeson.model.filterrules.MatchEventId;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class EventAutoInclusionFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private Set<Integer> leagues = new HashSet<Integer>();
    private Set<MatchEventId> matchEventIds = new HashSet<MatchEventId>();

    public EventAutoInclusionFilterRule() {
        this.ruleType = 21;
    }

    @Override
    public boolean isComplied(IBetEvent event, ISnapshot<?> snapshot) {
        IBetMatch match = snapshot.match(event.matchId());
        int leagueHashCode = match.league().hashCode();
        if (this.leagues.contains(leagueHashCode)) {
            return true;
        }
        MatchEventId matchEventId = new MatchEventId(event.matchId(), event.id());
        return this.matchEventIds.contains(matchEventId);
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        throw new UnsupportedOperationException("Should not call this method but call isComplied(IBetEvent, ISnapshot) instead.");
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        TreeSet<Integer> leaguesTreeSet = new TreeSet<Integer>();
        leaguesTreeSet.addAll(this.leagues);
        Iterator iterator = leaguesTreeSet.iterator();
        while (iterator.hasNext()) {
            int league = (Integer)iterator.next();
            result = 31 * result + league;
        }
        TreeSet<MatchEventId> matchEventIdsTreeSet = new TreeSet<MatchEventId>();
        matchEventIdsTreeSet.addAll(this.matchEventIds);
        for (MatchEventId matchEventId : matchEventIdsTreeSet) {
            result = 31 * result + matchEventId.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof EventAutoInclusionFilterRule) {
            EventAutoInclusionFilterRule rule = (EventAutoInclusionFilterRule)o;
            if (!this.leagues.equals(rule.getLeagues())) {
                return -1;
            }
            if (!this.matchEventIds.equals(rule.getMatchEventIds())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public Set<Integer> getLeagues() {
        return this.leagues;
    }

    public void setLeagues(Set<Integer> leagues) {
        this.leagues = leagues;
    }

    public Set<MatchEventId> getMatchEventIds() {
        return this.matchEventIds;
    }

    public void setMatchEventIds(Set<MatchEventId> matchEventId) {
        this.matchEventIds = matchEventId;
    }
}

