/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import java.util.TreeMap;

public enum FilterOperator {
    FILTER_IGNORED(0, " "),
    FILTER_LARGER(1, ">"),
    FILTER_LARGER_EQUAL(2, ">="),
    FILTER_EQUAL(3, "="),
    FILTER_SMALLER_EQUAL(4, "<="),
    FILTER_SMALLER(5, "<"),
    FILTER_WITHIN(6, "WITHIN"),
    FILTER_OUTOF(7, "OUTOF");

    private int _value;
    private String _display;
    private static final TreeMap<Integer, FilterOperator> _map;

    private FilterOperator(int value, String display) {
        this._value = value;
        this._display = display;
    }

    public int value() {
        return this._value;
    }

    public String display() {
        return this._display;
    }

    public static FilterOperator fromInt(int value) {
        return _map.get(new Integer(value));
    }

    public String toString() {
        return this._display;
    }

    static {
        _map = new TreeMap();
        for (FilterOperator targetType : FilterOperator.values()) {
            _map.put(new Integer(targetType.value()), targetType);
        }
    }
}

