/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.twoside.IB2Match;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class LeagueTeamRegexFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private String includeRegex = "";
    @JsonIgnore
    private Pattern pattern;

    public LeagueTeamRegexFilterRule() {
        this.ruleType = 23;
    }

    private boolean passedFilter(String input) {
        if (this.includeRegex == null || this.includeRegex.isEmpty()) {
            return true;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.includeRegex);
        }
        Matcher matcher = this.pattern.matcher(input);
        return matcher.find();
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof LeagueTeamRegexFilterRule) {
            LeagueTeamRegexFilterRule filterRule = (LeagueTeamRegexFilterRule)o;
            String comparingRegex = filterRule.getIncludeRegex();
            if (this.includeRegex == null && comparingRegex == null) {
                return 0;
            }
            if (this.includeRegex != null && comparingRegex != null && this.includeRegex.equals(comparingRegex)) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int hashCode = initialHashCode;
        hashCode = this.includeRegex == null || this.includeRegex.isEmpty() ? 17 * hashCode : 17 * hashCode + this.includeRegex.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public void setIncludeRegex(String includeRegex) {
        this.includeRegex = includeRegex;
        if (includeRegex != null) {
            this.pattern = Pattern.compile(includeRegex);
        }
    }

    @Override
    public boolean isComplied(IBetMatch m) {
        boolean isLeaguePassed = this.passedFilter(((IB2Match)m).league().toLowerCase());
        boolean isHostPassed = this.passedFilter(((IB2Match)m).participantOne().toLowerCase());
        boolean isGuestPassed = this.passedFilter(((IB2Match)m).participantTwo().toLowerCase());
        return isLeaguePassed || isHostPassed || isGuestPassed;
    }
}

