/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;
import jayeson.model.filterrules.MatchEventId;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class MatchEventIdFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private Set<MatchEventId> ids = new TreeSet<MatchEventId>();

    public MatchEventIdFilterRule() {
        this.ruleType = 28;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        MatchEventId id = new MatchEventId(event.matchId(), event.id());
        return this.ids.contains(id);
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.ids == null || this.ids.isEmpty()) {
            result = 31 * result;
        } else {
            for (MatchEventId matchEventId : this.ids) {
                result = 31 * result + matchEventId.hashCode();
            }
        }
        return result;
    }

    public Set<MatchEventId> getIds() {
        return this.ids;
    }

    public void setMatchEventIds(Set<MatchEventId> matchEventIds) {
        this.ids = matchEventIds;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof MatchEventIdFilterRule) {
            MatchEventIdFilterRule rule = (MatchEventIdFilterRule)o;
            if (!this.ids.equals(rule.getIds())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }
}

