/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.IB2Event;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class OddAvailabilityFilterRule<T extends TimeType>
extends GeneralDataFilterRule
implements IEventFilterRule {
    private Logger logger = LoggerFactory.getLogger(OddAvailabilityFilterRule.class);
    private Set<OddType> oddTypes = new HashSet<OddType>();
    private Set<T> timeTypes = new HashSet<T>();
    private Set<PivotType> pivotTypes = new HashSet<PivotType>();
    private Set<String> companies = new HashSet<String>();

    public OddAvailabilityFilterRule() {
        this.ruleType = 13;
    }

    public Set<OddType> getOddTypes() {
        return this.oddTypes;
    }

    public void setOddTypes(Set<OddType> oddTypes) {
        this.oddTypes = oddTypes;
    }

    public Set<T> getTimeTypes() {
        return this.timeTypes;
    }

    public void setTimeTypes(Set<T> timeTypes) {
        this.timeTypes = timeTypes;
    }

    public Set<PivotType> getPivotTypes() {
        return this.pivotTypes;
    }

    public void setPivotTypes(Set<PivotType> pivotTypes) {
        this.pivotTypes = pivotTypes;
    }

    public Set<String> getCompanies() {
        return this.companies;
    }

    public void setCompanies(Set<String> companies) {
        this.companies = companies;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        boolean isComplied = true;
        if (!this.hasOddTypesInEvent(event)) {
            return false;
        }
        if (!this.hasTimeTypesInEvent(event)) {
            return false;
        }
        if (!this.hasPivotTypesInEvent(event)) {
            return false;
        }
        if (!this.hasCompaniesInEvent(event)) {
            return false;
        }
        return isComplied;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof OddAvailabilityFilterRule) {
            OddAvailabilityFilterRule rule = (OddAvailabilityFilterRule)o;
            if (this.getOddTypes() != null && rule.getOddTypes() != null) {
                if (!this.compareOddTypes(rule.getOddTypes())) {
                    return -1;
                }
            } else {
                return -1;
            }
            if (this.getTimeTypes() != null && rule.getTimeTypes() != null) {
                if (!this.compareTimeTypes(rule.getTimeTypes())) {
                    return -1;
                }
            } else {
                return -1;
            }
            if (this.getPivotTypes() != null && rule.getPivotTypes() != null) {
                if (!this.comparePivotTypes(rule.getPivotTypes())) {
                    return -1;
                }
            } else {
                return -1;
            }
            if (this.getCompanies() != null && rule.getCompanies() != null) {
                if (!this.compareCompanies(rule.getCompanies())) {
                    return -1;
                }
            } else {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.oddTypes == null || this.oddTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<OddType> oTypes = new TreeSet<OddType>();
            oTypes.addAll(this.oddTypes);
            for (OddType oddType : oTypes) {
                result = 31 * result + oddType.hashCode();
            }
        }
        if (this.timeTypes == null || this.timeTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<T> tTypes = new TreeSet<T>();
            tTypes.addAll(this.timeTypes);
            for (TimeType timeType : tTypes) {
                result = 31 * result + timeType.hashCode();
            }
        }
        if (this.pivotTypes == null || this.pivotTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<PivotType> pTypes = new TreeSet<PivotType>();
            pTypes.addAll(this.pivotTypes);
            for (PivotType pivotType : pTypes) {
                result = 31 * result + pivotType.hashCode();
            }
        }
        if (this.companies == null || this.companies.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<String> treeSetCompanies = new TreeSet<String>();
            treeSetCompanies.addAll(this.companies);
            for (String string : treeSetCompanies) {
                result = 31 * result + string.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    private boolean hasOddTypesInEvent(IBetEvent event) {
        for (OddType type : this.getOddTypes()) {
            if (!event.hasOddType(type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTimeTypesInEvent(IBetEvent event) {
        for (TimeType type : this.getTimeTypes()) {
            if (!event.hasTimeType(type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPivotTypesInEvent(IBetEvent event) {
        if (!(event instanceof IB2Event)) {
            return false;
        }
        IB2Event b2Event = (IB2Event)event;
        for (PivotType type : this.getPivotTypes()) {
            if (!b2Event.hasPivotType(type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCompaniesInEvent(IBetEvent event) {
        for (String source : this.getCompanies()) {
            if (!event.hasSportbook(source.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private boolean compareOddTypes(Set<OddType> types) {
        return this.getOddTypes().equals(types);
    }

    private boolean compareTimeTypes(Set<T> types) {
        return this.getTimeTypes().equals(types);
    }

    private boolean comparePivotTypes(Set<PivotType> types) {
        return this.getPivotTypes().equals(types);
    }

    private boolean compareCompanies(Set<String> companies) {
        return this.getCompanies().equals(companies);
    }
}

