/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class PivotBiasFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    List<PivotBias> pivotBiases = new ArrayList<PivotBias>();

    public PivotBiasFilterRule() {
        this.ruleType = 25;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        if (!(record instanceof IB2Record)) {
            return false;
        }
        IB2Record b2Record = (IB2Record)record;
        for (PivotBias pivotBias : this.pivotBiases) {
            if (b2Record.pivotBias() != pivotBias) continue;
            return true;
        }
        return false;
    }

    public List<PivotBias> getPivotBiases() {
        return this.pivotBiases;
    }

    public void setPivotBiases(List<PivotBias> pivotBiases) {
        this.pivotBiases = pivotBiases;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof PivotBiasFilterRule) {
            PivotBiasFilterRule rule = (PivotBiasFilterRule)o;
            if (this.getPivotBiases().size() != rule.getPivotBiases().size()) {
                return -1;
            }
            for (PivotBias curBias : this.getPivotBiases()) {
                boolean notFound = true;
                for (PivotBias comBias : rule.getPivotBiases()) {
                    if (!curBias.equals((Object)comBias)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.pivotBiases == null || this.pivotBiases.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<PivotBias> pTypes = new TreeSet<PivotBias>();
            pTypes.addAll(this.pivotBiases);
            for (PivotBias type : pTypes) {
                result = 31 * result + type.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

