/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class PivotTypeFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private List<PivotType> types = new ArrayList<PivotType>();

    public PivotTypeFilterRule() {
        this.ruleType = 5;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        if (!(record instanceof IB2Record)) {
            return false;
        }
        IB2Record b2Record = (IB2Record)record;
        for (PivotType type : this.types) {
            if (b2Record.pivotType() != type) continue;
            return true;
        }
        return false;
    }

    public List<PivotType> getTypes() {
        return this.types;
    }

    public void setTypes(List<PivotType> types) {
        this.types = types;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof PivotTypeFilterRule) {
            PivotTypeFilterRule rule = (PivotTypeFilterRule)o;
            if (this.getTypes().size() != rule.getTypes().size()) {
                return -1;
            }
            for (PivotType curType : this.getTypes()) {
                boolean notFound = true;
                for (PivotType comType : rule.getTypes()) {
                    if (!curType.equals((Object)comType)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.types == null || this.types.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<PivotType> pTypes = new TreeSet<PivotType>();
            pTypes.addAll(this.types);
            for (PivotType type : pTypes) {
                result = 31 * result + type.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

