/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.lib.feed.soccer.SoccerEventState;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.FilterOperator;
import jayeson.model.filterrules.GeneralDataFilterRule;
import jayeson.model.filterrules.OperatorSubject;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class RedcardFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private FilterOperator operator = FilterOperator.FILTER_IGNORED;
    private OperatorSubject subject = OperatorSubject.HOST;
    private int expelled;

    public RedcardFilterRule() {
        this.ruleType = 6;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        if (this.operator == FilterOperator.FILTER_IGNORED) {
            return true;
        }
        if (!(event instanceof SoccerEvent)) {
            throw new UnsupportedOperationException();
        }
        SoccerEventState state = (SoccerEventState)event.eventState();
        switch (this.subject) {
            case HOST: {
                return this.isCompliedByExpelled(this.operator, state.hostCard(), this.expelled);
            }
            case GUEST: {
                return this.isCompliedByExpelled(this.operator, state.guestCard(), this.expelled);
            }
            case DIFFERENCE: {
                int expelledDiff = Math.abs(state.hostCard() - state.guestCard());
                return this.isCompliedByExpelled(this.operator, expelledDiff, this.expelled);
            }
            case HOST_LEADING: {
                int hostLeading = state.hostCard() - state.guestCard();
                return this.isCompliedByExpelled(this.operator, hostLeading, this.expelled);
            }
            case GUEST_LEADING: {
                int guestLeading = state.guestCard() - state.hostCard();
                return this.isCompliedByExpelled(this.operator, guestLeading, this.expelled);
            }
        }
        return false;
    }

    private boolean isCompliedByExpelled(FilterOperator filterType, int expelled, int criteria) {
        if (criteria >= 0) {
            switch (filterType) {
                case FILTER_LARGER: {
                    return expelled > criteria;
                }
                case FILTER_LARGER_EQUAL: {
                    return expelled >= criteria;
                }
                case FILTER_EQUAL: {
                    return expelled == criteria;
                }
                case FILTER_SMALLER_EQUAL: {
                    return expelled <= criteria;
                }
                case FILTER_SMALLER: {
                    return expelled < criteria;
                }
            }
            return true;
        }
        return true;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public OperatorSubject getSubject() {
        return this.subject;
    }

    public void setSubject(OperatorSubject subject) {
        this.subject = subject;
    }

    public int getExpelled() {
        return this.expelled;
    }

    public void setExpelled(int expelled) {
        this.expelled = expelled;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof RedcardFilterRule) {
            RedcardFilterRule rule = (RedcardFilterRule)o;
            if (this.getExpelled() != rule.getExpelled()) {
                return -1;
            }
            if (!this.getOperator().equals((Object)rule.getOperator())) {
                return -1;
            }
            if (!this.getSubject().equals((Object)rule.getSubject())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + this.expelled;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

