/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.TargetType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class TargetFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private TargetType targetType = TargetType.OVER;

    public TargetFilterRule() {
        this.ruleType = 8;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        if (!(record instanceof IB2Record)) {
            return false;
        }
        IB2Record b2Record = (IB2Record)record;
        return b2Record.isAllowed(this.targetType);
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof TargetFilterRule) {
            TargetFilterRule rule = (TargetFilterRule)o;
            if (!this.getTargetType().equals((Object)rule.getTargetType())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

