/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed;

import akka.actor.ActorRefWithCell;
import akka.actor.ExtendedActorSystem;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRefResolver;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.adapter.package$;
import akka.actor.typed.scaladsl.adapter.package$ClassicActorSystemOps$;
import akka.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import akka.actor.typed.scaladsl.adapter.package$TypedActorSystemOps$;
import akka.annotation.InternalApi;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3Qa\u0002\u0005\u0001\u00199A\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I!\u0006\u0005\u0006O\u0001!\t\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019)\u0004\u0001)A\u0005c!)a\u0007\u0001C!o!)A\n\u0001C!\u001b\n!\u0012i\u0019;peJ+gMU3t_24XM]%na2T!!\u0003\u0006\u0002\u000bQL\b/\u001a3\u000b\u0005-a\u0011!B1di>\u0014(\"A\u0007\u0002\t\u0005\\7.Y\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003!I!A\u0005\u0005\u0003!\u0005\u001bGo\u001c:SK\u001a\u0014Vm]8mm\u0016\u0014\u0018AB:zgR,Wn\u0001\u00011\u0005YY\u0002c\u0001\t\u00183%\u0011\u0001\u0004\u0003\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0005\u0002\u001b71\u0001A!\u0003\u000f\u0002\u0003\u0003\u0005\tQ!\u0001\u001e\u0005\ryFeM\t\u0003=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012qAT8uQ&tw\r\u0005\u0002 K%\u0011a\u0005\t\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002*UA\u0011\u0001\u0003\u0001\u0005\u0006'\t\u0001\ra\u000b\u0019\u0003Y9\u00022\u0001E\f.!\tQb\u0006B\u0005\u001dU\u0005\u0005\t\u0011!B\u0001;\u0005i1\r\\1tg&\u001c7+_:uK6,\u0012!\r\t\u0003eMj\u0011AC\u0005\u0003i)\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fab\u00197bgNL7mU=ti\u0016l\u0007%A\u000bu_N+'/[1mSj\fG/[8o\r>\u0014X.\u0019;\u0016\u0005aRECA\u001dE!\tQ\u0014I\u0004\u0002<\u007fA\u0011A\bI\u0007\u0002{)\u0011a\bF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001\u0003\u0013A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001\u0011\u0011\t\u000b\u0015+\u0001\u0019\u0001$\u0002\u0007I,g\rE\u0002\u0011\u000f&K!\u0001\u0013\u0005\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\u0004\"A\u0007&\u0005\u000b-+!\u0019A\u000f\u0003\u0003Q\u000bqB]3t_24X-Q2u_J\u0014VMZ\u000b\u0003\u001dF#\"a\u0014*\u0011\u0007A9\u0005\u000b\u0005\u0002\u001b#\u0012)1J\u0002b\u0001;!)1K\u0002a\u0001s\u0005\u00112/\u001a:jC2L'0\u001a3BGR|'OU3gQ\t\u0001Q\u000b\u0005\u0002W36\tqK\u0003\u0002Y\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i;&aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public class ActorRefResolverImpl
extends ActorRefResolver {
    private final ActorSystem<?> system;
    private final ExtendedActorSystem classicSystem;

    private ExtendedActorSystem classicSystem() {
        return this.classicSystem;
    }

    @Override
    public <T> String toSerializationFormat(ActorRef<T> ref) {
        akka.actor.ActorRef actorRef = package$TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(ref));
        if (actorRef instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)actorRef;
            ExtendedActorSystem originSystem = (ExtendedActorSystem)actorRefWithCell.underlying().system();
            if (originSystem == this.classicSystem()) {
                return this.toSerializationFormatWithAddress$1(ref);
            }
            throw new IllegalArgumentException(new StringBuilder(178).append("ActorRefResolver for ActorSystem [").append(this.classicSystem().provider().getDefaultAddress()).append("] shouldn't be used for ").append("serialization of ActorRef that originates from another ActorSystem ").append("[").append(originSystem.provider().getDefaultAddress()).append("]. Use the ActorRefResolver for that system instead.").toString());
        }
        return this.toSerializationFormatWithAddress$1(ref);
    }

    @Override
    public <T> ActorRef<T> resolveActorRef(String serializedActorRef) {
        akka.actor.ActorRef ref = this.classicSystem().provider().resolveActorRef(serializedActorRef);
        if (ref == this.classicSystem().provider().ignoreRef()) {
            return package$ClassicActorSystemOps$.MODULE$.toTyped$extension(package$.MODULE$.ClassicActorSystemOps((akka.actor.ActorSystem)this.classicSystem())).ignoreRef();
        }
        return package$.MODULE$.actorRefAdapter(ref);
    }

    private final String toSerializationFormatWithAddress$1(ActorRef ref$1) {
        return ref$1.path().toSerializationFormatWithAddress(this.system.address());
    }

    public ActorRefResolverImpl(ActorSystem<?> system) {
        this.system = system;
        this.classicSystem = (ExtendedActorSystem)package$TypedActorSystemOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorSystemOps(system));
    }
}

