/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.internal;

import akka.actor.Cancellable;
import akka.actor.NotInfluenceReceiveTimeout;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorRef$ActorRefOps$;
import akka.actor.typed.Behavior;
import akka.actor.typed.internal.TimerSchedulerCrossDslSupport;
import akka.actor.typed.internal.TimerSchedulerImpl$;
import akka.actor.typed.internal.TimerSchedulerImpl$SingleMode$;
import akka.actor.typed.javadsl.TimerScheduler;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.package$;
import akka.actor.typed.scaladsl.package$LoggerOps$;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import java.time.Duration;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\ruACA\u0001\u0003\u0007A\t!a\u0004\u0002\u0014\u0019Q\u0011qCA\u0002\u0011\u0003\ty!!\u0007\t\u000f\u0005\u001d\u0012\u0001\"\u0001\u0002,\u00191\u0011QF\u0001C\u0003_A!\"!\u0015\u0004\u0005+\u0007I\u0011AA*\u0011)\tYf\u0001B\tB\u0003%\u0011Q\u000b\u0005\u000b\u0003;\u001a!Q3A\u0005\u0002\u0005}\u0003BCA9\u0007\tE\t\u0015!\u0003\u0002b!Q\u00111O\u0002\u0003\u0016\u0004%\t!!\u001e\t\u0015\u0005u4A!E!\u0002\u0013\t9\b\u0003\u0006\u0002\u0000\r\u0011)\u001a!C\u0001\u0003\u0003C!\"!#\u0004\u0005#\u0005\u000b\u0011BAB\u0011)\tYi\u0001BK\u0002\u0013\u0005\u0011Q\u0012\u0005\u000b\u0003/\u001b!\u0011#Q\u0001\n\u0005=\u0005bBA\u0014\u0007\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003S\u001b\u0011\u0011!C\u0001\u0003WC\u0011\"a0\u0004#\u0003%\t!!1\t\u0013\u0005m7!%A\u0005\u0002\u0005u\u0007\"CAs\u0007E\u0005I\u0011AAt\u0011%\tyoAI\u0001\n\u0003\t\t\u0010C\u0005\u0002z\u000e\t\n\u0011\"\u0001\u0002|\"I!1A\u0002\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005/\u0019\u0011\u0011!C\u0001\u0003\u0003C\u0011B!\u0007\u0004\u0003\u0003%\tAa\u0007\t\u0013\t\u00052!!A\u0005B\t\r\u0002\"\u0003B\u0019\u0007\u0005\u0005I\u0011\u0001B\u001a\u0011%\u00119dAA\u0001\n\u0003\u0012I\u0004C\u0005\u0003>\r\t\t\u0011\"\u0011\u0003@!I!\u0011I\u0002\u0002\u0002\u0013\u0005#1\t\u0005\n\u0005\u000b\u001a\u0011\u0011!C!\u0005\u000f:\u0011Ba\u0013\u0002\u0003\u0003E\tA!\u0014\u0007\u0013\u00055\u0012!!A\t\u0002\t=\u0003bBA\u0014?\u0011\u0005!1\f\u0005\n\u0005\u0003z\u0012\u0011!C#\u0005\u0007B\u0011B!\u0018 \u0003\u0003%\tIa\u0018\t\u0013\tMt$!A\u0005\u0002\nU\u0004\"\u0003BH?\u0005\u0005I\u0011\u0002BI\r\u0019\u0011I*\u0001\t\u0003\u001c\"Q\u0011\u0011K\u0013\u0003\u0006\u0004%\t!a\u0015\t\u0015\u0005mSE!A!\u0002\u0013\t)\u0006\u0003\u0006\u0002\u0000\u0015\u0012)\u0019!C\u0001\u0003\u0003C!\"!#&\u0005\u0003\u0005\u000b\u0011BAB\u0011)\u0011i*\nBC\u0002\u0013\u0005!q\u0014\u0005\u000b\u0005C+#\u0011!Q\u0001\n\u0005m\u0001bBA\u0014K\u0011\u0005!1\u0015\u0005\b\u0005\u0003*C\u0011\tB\"\u0011\u001d\u0011),\u0001C\u0001\u0005oCqAa6\u0002\t\u0003\u0011INB\u0005\u0003|\u0006\u0001\n1%\u000b\u0003~\"9\u00111\u000f\u0019\u0007\u0002\u0005UdABB\u001e\u0003\u0011\u001bi\u0004\u0003\u0006\u0004\bI\u0012)\u001a!C\u0001\u0007\u0013A!ba\u00073\u0005#\u0005\u000b\u0011BB\u0006\u0011\u001d\t9C\rC\u0001\u0007\u007fAq!a\u001d3\t\u0003\n)\bC\u0005\u0002*J\n\t\u0011\"\u0001\u0004F!I\u0011q\u0018\u001a\u0012\u0002\u0013\u00051q\u0005\u0005\n\u0005\u0007\u0011\u0014\u0011!C!\u0005\u000bA\u0011Ba\u00063\u0003\u0003%\t!!!\t\u0013\te!'!A\u0005\u0002\r%\u0003\"\u0003B\u0011e\u0005\u0005I\u0011\tB\u0012\u0011%\u0011\tDMA\u0001\n\u0003\u0019i\u0005C\u0005\u00038I\n\t\u0011\"\u0011\u0004R!I!Q\b\u001a\u0002\u0002\u0013\u0005#q\b\u0005\n\u0005\u0003\u0012\u0014\u0011!C!\u0005\u0007B\u0011B!\u00123\u0003\u0003%\te!\u0016\b\u0013\r%\u0014!!A\t\n\r-d!CB\u001e\u0003\u0005\u0005\t\u0012BB7\u0011\u001d\t9c\u0011C\u0001\u0007wB\u0011B!\u0011D\u0003\u0003%)Ea\u0011\t\u0013\tu3)!A\u0005\u0002\u000eu\u0004\"\u0003B:\u0007\u0006\u0005I\u0011QBA\u0011%\u0011yiQA\u0001\n\u0013\u0011\tJ\u0002\u0004\u0004\u0002\u0005!51\u0001\u0005\u000b\u0007\u000fI%Q3A\u0005\u0002\r%\u0001BCB\u000e\u0013\nE\t\u0015!\u0003\u0004\f!9\u0011qE%\u0005\u0002\ru\u0001bBA:\u0013\u0012\u0005\u0013Q\u000f\u0005\n\u0003SK\u0015\u0011!C\u0001\u0007GA\u0011\"a0J#\u0003%\taa\n\t\u0013\t\r\u0011*!A\u0005B\t\u0015\u0001\"\u0003B\f\u0013\u0006\u0005I\u0011AAA\u0011%\u0011I\"SA\u0001\n\u0003\u0019Y\u0003C\u0005\u0003\"%\u000b\t\u0011\"\u0011\u0003$!I!\u0011G%\u0002\u0002\u0013\u00051q\u0006\u0005\n\u0005oI\u0015\u0011!C!\u0007gA\u0011B!\u0010J\u0003\u0003%\tEa\u0010\t\u0013\t\u0005\u0013*!A\u0005B\t\r\u0003\"\u0003B#\u0013\u0006\u0005I\u0011IB\u001c\u000f%\u00199)AA\u0001\u0012\u0013\u0019IIB\u0005\u0004\u0002\u0005\t\t\u0011#\u0003\u0004\f\"9\u0011q\u0005.\u0005\u0002\r=\u0005\"\u0003B!5\u0006\u0005IQ\tB\"\u0011%\u0011iFWA\u0001\n\u0003\u001b\t\nC\u0005\u0003ti\u000b\t\u0011\"!\u0004\u0016\"I!q\u0012.\u0002\u0002\u0013%!\u0011S\u0004\b\u00073\u000b\u0001\u0012RB0\r\u001d\u0019I&\u0001EE\u00077Bq!a\nb\t\u0003\u0019i\u0006C\u0004\u0002t\u0005$\t%!\u001e\t\u0013\t\r\u0011-!A\u0005B\t\u0015\u0001\"\u0003B\fC\u0006\u0005I\u0011AAA\u0011%\u0011I\"YA\u0001\n\u0003\u0019\t\u0007C\u0005\u0003\"\u0005\f\t\u0011\"\u0011\u0003$!I!\u0011G1\u0002\u0002\u0013\u00051Q\r\u0005\n\u0005{\t\u0017\u0011!C!\u0005\u007fA\u0011B!\u0011b\u0003\u0003%\tEa\u0011\t\u0013\t=\u0015-!A\u0005\n\tEe!CA\f\u0003\u0007\u0001\u0011qBBU\u0011)\u00119\u000f\u001cB\u0001B\u0003%1\u0011\u0018\u0005\b\u0003OaG\u0011AB^\u0011%\u0019\t\r\u001ca\u0001\n\u0013\u0019\u0019\rC\u0005\u0004Z2\u0004\r\u0011\"\u0003\u0004\\\"A1Q\u001d7!B\u0013\u0019)\rC\u0005\u0004h2\u0014\r\u0011\"\u0003\u0004j\"A1Q\u001e7!\u0002\u0013\u0019Y\u000fC\u0004\u0004p2$\te!=\t\u000f\r=H\u000e\"\u0011\u0004|\"9AQ\u00017\u0005B\u0011\u001d\u0001b\u0002C\u0003Y\u0012\u0005C\u0011\u0003\u0005\b\t7aG\u0011\tC\u000f\u0011\u001d!)\u0003\u001cC!\tOAq\u0001b\fm\t\u0013!\t\u0004C\u0004\u0005@1$\t\u0005\"\u0011\t\u000f\u0011\u0015C\u000e\"\u0011\u0005H!9A1\n7\u0005\n\u00115\u0003b\u0002C*Y\u0012\u0005CQ\u000b\u0005\b\t/bG\u0011\u0001C-\u0003I!\u0016.\\3s'\u000eDW\rZ;mKJLU\u000e\u001d7\u000b\t\u0005\u0015\u0011qA\u0001\tS:$XM\u001d8bY*!\u0011\u0011BA\u0006\u0003\u0015!\u0018\u0010]3e\u0015\u0011\ti!a\u0004\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005E\u0011\u0001B1lW\u0006\u00042!!\u0006\u0002\u001b\t\t\u0019A\u0001\nUS6,'oU2iK\u0012,H.\u001a:J[Bd7cA\u0001\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyB\u0003\u0002\u0002\"\u0005)1oY1mC&!\u0011QEA\u0010\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001\u0006\u0002\u0002\u0014\t)A+[7feV!\u0011\u0011GA3'\u001d\u0019\u00111DA\u001a\u0003s\u0001B!!\b\u00026%!\u0011qGA\u0010\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u000f\u0002L9!\u0011QHA$\u001d\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003S\ta\u0001\u0010:p_Rt\u0014BAA\u0011\u0013\u0011\tI%a\b\u0002\u000fA\f7m[1hK&!\u0011QJA(\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\tI%a\b\u0002\u0007-,\u00170\u0006\u0002\u0002VA!\u0011QDA,\u0013\u0011\tI&a\b\u0003\u0007\u0005s\u00170\u0001\u0003lKf\u0004\u0013aA7tOV\u0011\u0011\u0011\r\t\u0005\u0003G\n)\u0007\u0004\u0001\u0005\u000f\u0005\u001d4A1\u0001\u0002j\t\tA+\u0005\u0003\u0002l\u0005U\u0003\u0003BA\u000f\u0003[JA!a\u001c\u0002 \t9aj\u001c;iS:<\u0017\u0001B7tO\u0002\naA]3qK\u0006$XCAA<!\u0011\ti\"!\u001f\n\t\u0005m\u0014q\u0004\u0002\b\u0005>|G.Z1o\u0003\u001d\u0011X\r]3bi\u0002\n!bZ3oKJ\fG/[8o+\t\t\u0019\t\u0005\u0003\u0002\u001e\u0005\u0015\u0015\u0002BAD\u0003?\u00111!\u00138u\u0003-9WM\\3sCRLwN\u001c\u0011\u0002\tQ\f7o[\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00146\u0011\u00111B\u0005\u0005\u0003+\u000bYAA\u0006DC:\u001cW\r\u001c7bE2,\u0017!\u0002;bg.\u0004C\u0003DAN\u0003?\u000b\t+a)\u0002&\u0006\u001d\u0006#BAO\u0007\u0005\u0005T\"A\u0001\t\u000f\u0005Ec\u00021\u0001\u0002V!9\u0011Q\f\bA\u0002\u0005\u0005\u0004bBA:\u001d\u0001\u0007\u0011q\u000f\u0005\b\u0003\u007fr\u0001\u0019AAB\u0011\u001d\tYI\u0004a\u0001\u0003\u001f\u000bAaY8qsV!\u0011QVAZ)1\ty+!.\u00028\u0006e\u00161XA_!\u0015\tijAAY!\u0011\t\u0019'a-\u0005\u000f\u0005\u001dtB1\u0001\u0002j!I\u0011\u0011K\b\u0011\u0002\u0003\u0007\u0011Q\u000b\u0005\n\u0003;z\u0001\u0013!a\u0001\u0003cC\u0011\"a\u001d\u0010!\u0003\u0005\r!a\u001e\t\u0013\u0005}t\u0002%AA\u0002\u0005\r\u0005\"CAF\u001fA\u0005\t\u0019AAH\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*B!a1\u0002ZV\u0011\u0011Q\u0019\u0016\u0005\u0003+\n9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\u0011\t\u0019.a\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00065'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011q\r\tC\u0002\u0005%\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0003?\f\u0019/\u0006\u0002\u0002b*\"\u0011\u0011MAd\t\u001d\t9'\u0005b\u0001\u0003S\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0003\u0002j\u00065XCAAvU\u0011\t9(a2\u0005\u000f\u0005\u001d$C1\u0001\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"T\u0003BAz\u0003o,\"!!>+\t\u0005\r\u0015q\u0019\u0003\b\u0003O\u001a\"\u0019AA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*B!!@\u0003\u0002U\u0011\u0011q \u0016\u0005\u0003\u001f\u000b9\rB\u0004\u0002hQ\u0011\r!!\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0001\u0005\u0003\u0003\n\tMQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0005#\tAA[1wC&!!Q\u0003B\u0006\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA+\u0005;A\u0011Ba\b\u0018\u0003\u0003\u0005\r!a!\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0003\u0005\u0004\u0003(\t5\u0012QK\u0007\u0003\u0005SQAAa\u000b\u0002 \u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=\"\u0011\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002x\tU\u0002\"\u0003B\u00103\u0005\u0005\t\u0019AA+\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u001d!1\b\u0005\n\u0005?Q\u0012\u0011!a\u0001\u0003\u0007\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000f\ta!Z9vC2\u001cH\u0003BA<\u0005\u0013B\u0011Ba\b\u001e\u0003\u0003\u0005\r!!\u0016\u0002\u000bQKW.\u001a:\u0011\u0007\u0005uudE\u0003 \u00037\u0011\t\u0006\u0005\u0003\u0003T\teSB\u0001B+\u0015\u0011\u00119Fa\u0004\u0002\u0005%|\u0017\u0002BA'\u0005+\"\"A!\u0014\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\t\u0005$q\r\u000b\r\u0005G\u0012IGa\u001b\u0003n\t=$\u0011\u000f\t\u0006\u0003;\u001b!Q\r\t\u0005\u0003G\u00129\u0007B\u0004\u0002h\t\u0012\r!!\u001b\t\u000f\u0005E#\u00051\u0001\u0002V!9\u0011Q\f\u0012A\u0002\t\u0015\u0004bBA:E\u0001\u0007\u0011q\u000f\u0005\b\u0003\u007f\u0012\u0003\u0019AAB\u0011\u001d\tYI\ta\u0001\u0003\u001f\u000bq!\u001e8baBd\u00170\u0006\u0003\u0003x\t\u001dE\u0003\u0002B=\u0005\u0013\u0003b!!\b\u0003|\t}\u0014\u0002\u0002B?\u0003?\u0011aa\u00149uS>t\u0007CDA\u000f\u0005\u0003\u000b)F!\"\u0002x\u0005\r\u0015qR\u0005\u0005\u0005\u0007\u000byB\u0001\u0004UkBdW-\u000e\t\u0005\u0003G\u00129\tB\u0004\u0002h\r\u0012\r!!\u001b\t\u0013\t-5%!AA\u0002\t5\u0015a\u0001=%aA)\u0011QT\u0002\u0003\u0006\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0013\t\u0005\u0005\u0013\u0011)*\u0003\u0003\u0003\u0018\n-!AB(cU\u0016\u001cGO\u0001\u0005US6,'/T:h'\r)\u00131D\u0001\u0006_^tWM]\u000b\u0003\u00037\taa\\<oKJ\u0004C\u0003\u0003BS\u0005O\u0013IKa+\u0011\u0007\u0005uU\u0005C\u0004\u0002R1\u0002\r!!\u0016\t\u000f\u0005}D\u00061\u0001\u0002\u0004\"9!Q\u0014\u0017A\u0002\u0005m\u0011fA\u0013\u00030\u001a1!\u0011W\u0013\u0001\u0005g\u0013Q\u0002\u00107pG\u0006d\u0007e\u00195jY\u0012t4\u0003\u0002BX\u0005K\u000b!b^5uQRKW.\u001a:t+\u0011\u0011IL!2\u0015\t\tm&q\u0019\t\u0007\u0005{\u0013yLa1\u000e\u0005\u0005\u001d\u0011\u0002\u0002Ba\u0003\u000f\u0011\u0001BQ3iCZLwN\u001d\t\u0005\u0003G\u0012)\rB\u0004\u0002h9\u0012\r!!\u001b\t\u000f\t%g\u00061\u0001\u0003L\u00069a-Y2u_JL\b\u0003CA\u000f\u0005\u001b\u0014\tNa/\n\t\t=\u0017q\u0004\u0002\n\rVt7\r^5p]F\u0002b!!\u0006\u0003T\n\r\u0017\u0002\u0002Bk\u0003\u0007\u0011Q\u0004V5nKJ\u001c6\r[3ek2,'o\u0011:pgN$5\u000f\\*vaB|'\u000f^\u0001\u000foJ\f\u0007oV5uQRKW.\u001a:t+\u0011\u0011YNa9\u0015\t\tu'Q\u001f\u000b\u0005\u0005?\u0014)\u000f\u0005\u0004\u0003>\n}&\u0011\u001d\t\u0005\u0003G\u0012\u0019\u000fB\u0004\u0002h=\u0012\r!!\u001b\t\u000f\t\u001dx\u00061\u0001\u0003j\u0006\u00191\r\u001e=\u0011\r\t-(\u0011\u001fBq\u001b\t\u0011iO\u0003\u0003\u0003p\u0006\u001d\u0011\u0001C:dC2\fGm\u001d7\n\t\tM(Q\u001e\u0002\r\u0003\u000e$xN]\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u0013|\u0003\u0019\u0001B|!!\tiB!4\u0003z\n}\u0007CBA\u000b\u0005'\u0014\tOA\u0005US6,'/T8eKN\u0019\u0001'a\u0007*\tAJ%'\u0019\u0002\u000f\r&DX\r\u001a#fY\u0006LXj\u001c3f'%I\u00151DB\u0003\u0003g\tI\u0004E\u0002\u0002\u001eB\nA\"\u001b8ji&\fG\u000eR3mCf,\"aa\u0003\u0011\t\r51qC\u0007\u0003\u0007\u001fQAa!\u0005\u0004\u0014\u0005AA-\u001e:bi&|gN\u0003\u0003\u0004\u0016\u0005}\u0011AC2p]\u000e,(O]3oi&!1\u0011DB\b\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fQ\"\u001b8ji&\fG\u000eR3mCf\u0004C\u0003BB\u0010\u0007C\u00012!!(J\u0011\u001d\u00199\u0001\u0014a\u0001\u0007\u0017!Baa\b\u0004&!I1q\u0001(\u0011\u0002\u0003\u000711B\u000b\u0003\u0007SQCaa\u0003\u0002HR!\u0011QKB\u0017\u0011%\u0011yBUA\u0001\u0002\u0004\t\u0019\t\u0006\u0003\u0002x\rE\u0002\"\u0003B\u0010)\u0006\u0005\t\u0019AA+)\u0011\u00119a!\u000e\t\u0013\t}Q+!AA\u0002\u0005\rE\u0003BA<\u0007sA\u0011Ba\bY\u0003\u0003\u0005\r!!\u0016\u0003\u001b\u0019K\u00070\u001a3SCR,Wj\u001c3f'%\u0011\u00141DB\u0003\u0003g\tI\u0004\u0006\u0003\u0004B\r\r\u0003cAAOe!91qA\u001bA\u0002\r-A\u0003BB!\u0007\u000fB\u0011ba\u00028!\u0003\u0005\raa\u0003\u0015\t\u0005U31\n\u0005\n\u0005?Y\u0014\u0011!a\u0001\u0003\u0007#B!a\u001e\u0004P!I!qD\u001f\u0002\u0002\u0003\u0007\u0011Q\u000b\u000b\u0005\u0005\u000f\u0019\u0019\u0006C\u0005\u0003 y\n\t\u00111\u0001\u0002\u0004R!\u0011qOB,\u0011%\u0011y\"QA\u0001\u0002\u0004\t)F\u0001\u0006TS:<G.Z'pI\u0016\u001c\u0012\"YA\u000e\u0007\u000b\t\u0019$!\u000f\u0015\u0005\r}\u0003cAAOCR!\u0011QKB2\u0011%\u0011yBZA\u0001\u0002\u0004\t\u0019\t\u0006\u0003\u0002x\r\u001d\u0004\"\u0003B\u0010Q\u0006\u0005\t\u0019AA+\u000351\u0015\u000e_3e%\u0006$X-T8eKB\u0019\u0011QT\"\u0014\u000b\r\u001byG!\u0015\u0011\u0011\rE4qOB\u0006\u0007\u0003j!aa\u001d\u000b\t\rU\u0014qD\u0001\beVtG/[7f\u0013\u0011\u0019Iha\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0004lQ!1\u0011IB@\u0011\u001d\u00199A\u0012a\u0001\u0007\u0017!Baa!\u0004\u0006B1\u0011Q\u0004B>\u0007\u0017A\u0011Ba#H\u0003\u0003\u0005\ra!\u0011\u0002\u001d\u0019K\u00070\u001a3EK2\f\u00170T8eKB\u0019\u0011Q\u0014.\u0014\u000bi\u001biI!\u0015\u0011\u0011\rE4qOB\u0006\u0007?!\"a!#\u0015\t\r}11\u0013\u0005\b\u0007\u000fi\u0006\u0019AB\u0006)\u0011\u0019\u0019ia&\t\u0013\t-e,!AA\u0002\r}\u0011AC*j]\u001edW-T8eK\"\u001a\u0011a!(\u0011\t\r}51U\u0007\u0003\u0007CSA!a5\u0002\u0010%!1QUBQ\u0005-Ie\u000e^3s]\u0006d\u0017\t]5)\u0007\u0001\u0019i*\u0006\u0003\u0004,\u000eU6c\u00027\u0002\u001c\r56q\u0017\t\u0007\u0005W\u001cyka-\n\t\rE&Q\u001e\u0002\u000f)&lWM]*dQ\u0016$W\u000f\\3s!\u0011\t\u0019g!.\u0005\u000f\u0005\u001dDN1\u0001\u0002jA1\u0011Q\u0003Bj\u0007g\u0003bAa;\u0003r\u000eMF\u0003BB_\u0007\u007f\u0003R!!\u0006m\u0007gCqAa:o\u0001\u0004\u0019I,\u0001\u0004uS6,'o]\u000b\u0003\u0007\u000b\u0004\u0002ba2\u0004P\u0006U3Q\u001b\b\u0005\u0007\u0013\u001cY\r\u0005\u0003\u0002@\u0005}\u0011\u0002BBg\u0003?\ta\u0001\u0015:fI\u00164\u0017\u0002BBi\u0007'\u00141!T1q\u0015\u0011\u0019i-a\b\u0011\u000b\r]7aa-\u000f\u0007\u0005U\u0001!\u0001\u0006uS6,'o]0%KF$Ba!8\u0004dB!\u0011QDBp\u0013\u0011\u0019\t/a\b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005?\u0001\u0018\u0011!a\u0001\u0007\u000b\fq\u0001^5nKJ\u001c\b%\u0001\u0005uS6,'oR3o+\t\u0019Y\u000f\u0005\u0004\u0003(\t5\u00121Q\u0001\ni&lWM]$f]\u0002\nQc\u001d;beR$\u0016.\\3s\u0003R4\u0015\u000e_3e%\u0006$X\r\u0006\u0005\u0004^\u000eM8Q_B|\u0011\u001d\t\t\u0006\u001ea\u0001\u0003+Bq!!\u0018u\u0001\u0004\u0019\u0019\fC\u0004\u0004zR\u0004\raa\u0003\u0002\u0011%tG/\u001a:wC2$\"b!8\u0004~\u000e}H\u0011\u0001C\u0002\u0011\u001d\t\t&\u001ea\u0001\u0003+Bq!!\u0018v\u0001\u0004\u0019\u0019\fC\u0004\u0004\bU\u0004\raa\u0003\t\u000f\reX\u000f1\u0001\u0004\f\u0005A2\u000f^1siRKW.\u001a:XSRDg)\u001b=fI\u0012+G.Y=\u0015\u0011\ruG\u0011\u0002C\u0006\t\u001bAq!!\u0015w\u0001\u0004\t)\u0006C\u0004\u0002^Y\u0004\raa-\t\u000f\u0011=a\u000f1\u0001\u0004\f\u0005)A-\u001a7bsRQ1Q\u001cC\n\t+!9\u0002\"\u0007\t\u000f\u0005Es\u000f1\u0001\u0002V!9\u0011QL<A\u0002\rM\u0006bBB\u0004o\u0002\u000711\u0002\u0005\b\t\u001f9\b\u0019AB\u0006\u0003I\u0019H/\u0019:u!\u0016\u0014\u0018n\u001c3jGRKW.\u001a:\u0015\u0011\ruGq\u0004C\u0011\tGAq!!\u0015y\u0001\u0004\t)\u0006C\u0004\u0002^a\u0004\raa-\t\u000f\re\b\u00101\u0001\u0004\f\u0005\u00012\u000f^1siNKgn\u001a7f)&lWM\u001d\u000b\t\u0007;$I\u0003b\u000b\u0005.!9\u0011\u0011K=A\u0002\u0005U\u0003bBA/s\u0002\u000711\u0017\u0005\b\t\u001fI\b\u0019AB\u0006\u0003)\u0019H/\u0019:u)&lWM\u001d\u000b\u000b\u0007;$\u0019\u0004\"\u000e\u00058\u0011e\u0002bBA)u\u0002\u0007\u0011Q\u000b\u0005\b\u0003;R\b\u0019ABZ\u0011\u001d!yA\u001fa\u0001\u0007\u0017Aq\u0001b\u000f{\u0001\u0004!i$\u0001\u0003n_\u0012,\u0007cABla\u0005i\u0011n\u001d+j[\u0016\u0014\u0018i\u0019;jm\u0016$B!a\u001e\u0005D!9\u0011\u0011K>A\u0002\u0005U\u0013AB2b]\u000e,G\u000e\u0006\u0003\u0004^\u0012%\u0003bBA)y\u0002\u0007\u0011QK\u0001\fG\u0006t7-\u001a7US6,'\u000f\u0006\u0003\u0004^\u0012=\u0003b\u0002C){\u0002\u00071Q[\u0001\u0006i&lWM]\u0001\nG\u0006t7-\u001a7BY2$\"a!8\u0002#%tG/\u001a:dKB$H+[7fe6\u001bx\r\u0006\u0004\u0005\\\u0011\u001dD1\u0010\t\u0007\t;\"\u0019ga-\u000e\u0005\u0011}#\u0002\u0002C1\u0003\u001f\tA!\u001e;jY&!AQ\rC0\u0005%y\u0005\u000f^5p]Z\u000bG\u000eC\u0004\u0005j}\u0004\r\u0001b\u001b\u0002\u00071|w\r\u0005\u0003\u0005n\u0011]TB\u0001C8\u0015\u0011!\t\bb\u001d\u0002\u000bMdg\r\u000e6\u000b\u0005\u0011U\u0014aA8sO&!A\u0011\u0010C8\u0005\u0019aunZ4fe\"9AQP@A\u0002\u0011}\u0014\u0001\u0003;j[\u0016\u0014Xj]4\u0011\u0007\r]W\u0005K\u0002m\u0007;\u0003")
@InternalApi
public class TimerSchedulerImpl<T>
implements TimerSchedulerCrossDslSupport<T> {
    private final ActorContext<T> ctx;
    private Map<Object, Timer<T>> timers;
    private final Iterator<Object> timerGen;

    public static <T> Behavior<T> wrapWithTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> factory, ActorContext<T> ctx) {
        return TimerSchedulerImpl$.MODULE$.wrapWithTimers(factory, ctx);
    }

    public static <T> Behavior<T> withTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> factory) {
        return TimerSchedulerImpl$.MODULE$.withTimers(factory);
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, delay);
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration initialDelay, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, initialDelay, delay);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, interval);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration initialDelay, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, initialDelay, interval);
    }

    @Override
    public final void startPeriodicTimer(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startPeriodicTimer$(this, key, msg, interval);
    }

    @Override
    public final void startSingleTimer(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startSingleTimer$(this, key, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration initialDelay, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration initialDelay, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, Duration delay) {
        TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration delay) {
        akka.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        akka.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration interval) {
        akka.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        akka.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, FiniteDuration delay) {
        akka.actor.typed.scaladsl.TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    private Map<Object, Timer<T>> timers() {
        return this.timers;
    }

    private void timers_$eq(Map<Object, Timer<T>> x$1) {
        this.timers = x$1;
    }

    private Iterator<Object> timerGen() {
        return this.timerGen;
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(initialDelay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(delay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(initialDelay));
    }

    @Override
    public void startPeriodicTimer(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startSingleTimer(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, TimerSchedulerImpl$SingleMode$.MODULE$);
    }

    private void startTimer(Object key, T msg, FiniteDuration delay, TimerMode mode) {
        Cancellable cancellable;
        Option option = this.timers().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Timer t = (Timer)some.value();
            this.cancelTimer(t);
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError((Object)option);
        }
        int nextGen = BoxesRunTime.unboxToInt((Object)this.timerGen().next());
        Object timerMsg = msg instanceof NotInfluenceReceiveTimeout ? new NotInfluenceReceiveTimeout(this, key, nextGen){} : new TimerMsg(key, nextGen, this);
        TimerMode timerMode = mode;
        if (TimerSchedulerImpl$SingleMode$.MODULE$.equals(timerMode)) {
            cancellable = this.ctx.system().scheduler().scheduleOnce(delay, () -> TimerSchedulerImpl.$anonfun$startTimer$1(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (timerMode instanceof FixedDelayMode) {
            FixedDelayMode fixedDelayMode = (FixedDelayMode)timerMode;
            cancellable = this.ctx.system().scheduler().scheduleWithFixedDelay(fixedDelayMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$2(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (timerMode instanceof FixedRateMode) {
            FixedRateMode fixedRateMode = (FixedRateMode)timerMode;
            cancellable = this.ctx.system().scheduler().scheduleAtFixedRate(fixedRateMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$3(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else {
            throw new MatchError((Object)timerMode);
        }
        Cancellable task = cancellable;
        Timer<T> nextTimer = new Timer<T>(key, msg, mode.repeat(), nextGen, task);
        this.timers_$eq((Map)this.timers().updated(key, nextTimer));
    }

    @Override
    public boolean isTimerActive(Object key) {
        return this.timers().contains(key);
    }

    @Override
    public void cancel(Object key) {
        Option option = this.timers().get(key);
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Timer t = (Timer)some.value();
            this.cancelTimer(t);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void cancelTimer(Timer<T> timer) {
        timer.task().cancel();
        this.timers_$eq((Map)this.timers().$minus(timer.key()));
    }

    @Override
    public void cancelAll() {
        this.timers().valuesIterator().foreach((Function1 & Serializable)timer -> BoxesRunTime.boxToBoolean((boolean)TimerSchedulerImpl.$anonfun$cancelAll$1(timer)));
        this.timers_$eq(Predef$.MODULE$.Map().empty());
    }

    public T interceptTimerMsg(Logger log, TimerMsg timerMsg) {
        Option option = this.timers().get(timerMsg.key());
        if (None$.MODULE$.equals(option)) {
            log.debug("Received timer [{}] that has been removed, discarding", timerMsg.key());
            return (T)OptionVal$.MODULE$.none();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Timer t = (Timer)some.value();
            if (timerMsg.owner() != this) {
                log.debug("Received timer [{}] from old restarted instance, discarding", timerMsg.key());
                return (T)OptionVal$.MODULE$.none();
            }
            if (timerMsg.generation() == t.generation()) {
                if (!t.repeat()) {
                    this.timers_$eq((Map)this.timers().$minus(t.key()));
                }
                return (T)OptionVal.Some$.MODULE$.apply(t.msg());
            }
            if (log.isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(log), "Received timer [{}] from old generation [{}], expected generation [{}], discarding", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{timerMsg.key(), BoxesRunTime.boxToInteger((int)timerMsg.generation()), BoxesRunTime.boxToInteger((int)t.generation())}));
            }
            return (T)OptionVal$.MODULE$.none();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$startTimer$1(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$2(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$3(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps($this.ctx.self().unsafeUpcast()), timerMsg$1);
    }

    public static final /* synthetic */ boolean $anonfun$cancelAll$1(Timer timer) {
        return timer.task().cancel();
    }

    public TimerSchedulerImpl(ActorContext<T> ctx) {
        this.ctx = ctx;
        akka.actor.typed.scaladsl.TimerScheduler.$init$(this);
        TimerScheduler.$init$(this);
        TimerSchedulerCrossDslSupport.$init$(this);
        this.timers = Predef$.MODULE$.Map().empty();
        this.timerGen = scala.package$.MODULE$.Iterator().from(1);
    }

    private static class FixedDelayMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedDelayMode copy(FiniteDuration initialDelay) {
            return new FixedDelayMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedDelayMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.initialDelay();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedDelayMode;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "initialDelay";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FixedDelayMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            FixedDelayMode fixedDelayMode = (FixedDelayMode)x$1;
            FiniteDuration finiteDuration = this.initialDelay();
            FiniteDuration finiteDuration2 = fixedDelayMode.initialDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            if (!fixedDelayMode.canEqual(this)) return false;
            return true;
        }

        public FixedDelayMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    private static class FixedRateMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedRateMode copy(FiniteDuration initialDelay) {
            return new FixedRateMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedRateMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.initialDelay();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedRateMode;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "initialDelay";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FixedRateMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            FixedRateMode fixedRateMode = (FixedRateMode)x$1;
            FiniteDuration finiteDuration = this.initialDelay();
            FiniteDuration finiteDuration2 = fixedRateMode.initialDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            if (!fixedRateMode.canEqual(this)) return false;
            return true;
        }

        public FixedRateMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    public static final class Timer<T>
    implements Product,
    Serializable {
        private final Object key;
        private final T msg;
        private final boolean repeat;
        private final int generation;
        private final Cancellable task;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Object key() {
            return this.key;
        }

        public T msg() {
            return this.msg;
        }

        public boolean repeat() {
            return this.repeat;
        }

        public int generation() {
            return this.generation;
        }

        public Cancellable task() {
            return this.task;
        }

        public <T> Timer<T> copy(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            return new Timer<T>(key, msg, repeat, generation, task);
        }

        public <T> Object copy$default$1() {
            return this.key();
        }

        public <T> T copy$default$2() {
            return this.msg();
        }

        public <T> boolean copy$default$3() {
            return this.repeat();
        }

        public <T> int copy$default$4() {
            return this.generation();
        }

        public <T> Cancellable copy$default$5() {
            return this.task();
        }

        public String productPrefix() {
            return "Timer";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.msg();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.repeat());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.generation());
                }
                case 4: {
                    return this.task();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Timer;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "repeat";
                }
                case 3: {
                    return "generation";
                }
                case 4: {
                    return "task";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.msg()));
            n = Statics.mix((int)n, (int)(this.repeat() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.generation());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.task()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Timer)) return false;
            boolean bl = true;
            if (!bl) return false;
            Timer timer = (Timer)x$1;
            if (this.repeat() != timer.repeat()) return false;
            if (this.generation() != timer.generation()) return false;
            if (!BoxesRunTime.equals((Object)this.key(), (Object)timer.key())) return false;
            if (!BoxesRunTime.equals(this.msg(), timer.msg())) return false;
            Cancellable cancellable = this.task();
            Cancellable cancellable2 = timer.task();
            if (cancellable != null) {
                if (!cancellable.equals(cancellable2)) return false;
                return true;
            }
            if (cancellable2 == null) return true;
            return false;
        }

        public Timer(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            this.key = key;
            this.msg = msg;
            this.repeat = repeat;
            this.generation = generation;
            this.task = task;
            Product.$init$((Product)this);
        }
    }

    private static interface TimerMode {
        public boolean repeat();
    }

    public static class TimerMsg {
        private final Object key;
        private final int generation;
        private final Object owner;

        public Object key() {
            return this.key;
        }

        public int generation() {
            return this.generation;
        }

        public Object owner() {
            return this.owner;
        }

        public String toString() {
            return new StringBuilder(35).append("TimerMsg(key=").append(this.key()).append(", generation=").append(this.generation()).append(", owner=").append(this.owner()).append(")").toString();
        }

        public TimerMsg(Object key, int generation, Object owner) {
            this.key = key;
            this.generation = generation;
            this.owner = owner;
        }
    }
}

