/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.internal.receptionist;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorRef$ActorRefOps$;
import akka.actor.typed.Behavior;
import akka.actor.typed.internal.receptionist.AbstractServiceKey;
import akka.actor.typed.internal.receptionist.LocalReceptionist;
import akka.actor.typed.internal.receptionist.LocalReceptionist$State$;
import akka.actor.typed.internal.receptionist.ReceptionistBehaviorProvider;
import akka.actor.typed.internal.receptionist.ReceptionistMessages;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Deregistered$;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Listing$;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Registered$;
import akka.actor.typed.receptionist.Receptionist;
import akka.actor.typed.receptionist.ServiceKey;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.package$;
import akka.actor.typed.scaladsl.package$LoggerOps$;
import akka.annotation.InternalApi;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class LocalReceptionist$
implements ReceptionistBehaviorProvider {
    public static final LocalReceptionist$ MODULE$ = new LocalReceptionist$();
    private static final String name = "localReceptionist";

    @Override
    public String name() {
        return name;
    }

    @Override
    public Behavior<Receptionist.Command> behavior() {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> {
            ctx.setLoggerName(LocalReceptionist.class);
            return MODULE$.behavior(LocalReceptionist$State$.MODULE$.empty()).narrow();
        });
    }

    private Behavior<Object> behavior(LocalReceptionist.State state) {
        return (Behavior)((Object)Behaviors$.MODULE$.receive((Function2 & Serializable)(ctx, msg) -> {
            Object object = msg;
            if (object instanceof Receptionist.Command) {
                Receptionist.Command command = (Receptionist.Command)object;
                return this.onCommand$1((ActorContext)ctx, command, state);
            }
            if (object instanceof LocalReceptionist.InternalCommand) {
                LocalReceptionist.InternalCommand internalCommand = (LocalReceptionist.InternalCommand)object;
                return this.onInternal$1((ActorContext)ctx, internalCommand, state);
            }
            return Behaviors$.MODULE$.unhandled();
        }));
    }

    private static final void notifySubscribersFor$1(AbstractServiceKey key, LocalReceptionist.State newState$1) {
        Set newListing = newState$1.services().get((Object)key);
        ReceptionistMessages.Listing<Object> listing = ReceptionistMessages$Listing$.MODULE$.apply(key.asServiceKey(), newListing, newListing, true);
        newState$1.subscriptions().get((Object)key).foreach((Function1 & Serializable)x$1 -> {
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(x$1), listing);
            return BoxedUnit.UNIT;
        });
    }

    private final Behavior updateServices$1(Set changedKeysHint, Function1 f, LocalReceptionist.State state$1) {
        LocalReceptionist.State newState = (LocalReceptionist.State)f.apply((Object)state$1);
        changedKeysHint.foreach((Function1 & Serializable)key -> {
            LocalReceptionist$.notifySubscribersFor$1(key, newState);
            return BoxedUnit.UNIT;
        });
        return this.behavior(newState);
    }

    private static final void replyWithListing$1(ServiceKey key, ActorRef replyTo, LocalReceptionist.State state$1) {
        Set listing = state$1.services().get((Object)key);
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Listing$.MODULE$.apply(key, listing, listing, true));
    }

    private final Behavior onCommand$1(ActorContext ctx, Receptionist.Command cmd, LocalReceptionist.State state$1) {
        Receptionist.Command command = cmd;
        if (command instanceof ReceptionistMessages.Register) {
            Option<ActorRef<Receptionist.Registered>> option;
            ReceptionistMessages.Register register = (ReceptionistMessages.Register)command;
            ServiceKey key = register.key();
            ActorRef serviceInstance = register.serviceInstance();
            Option<ActorRef<Receptionist.Registered>> maybeReplyTo = register.replyTo();
            package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx.log()), "Actor was registered: {} {}", key, serviceInstance);
            if (!state$1.servicesPerActor().contains(serviceInstance)) {
                ctx.watchWith(serviceInstance, new LocalReceptionist.RegisteredActorTerminated(serviceInstance));
            }
            if ((option = maybeReplyTo) instanceof Some) {
                Some some = (Some)option;
                ActorRef replyTo = (ActorRef)some.value();
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Registered$.MODULE$.apply(key, serviceInstance));
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            return this.updateServices$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractServiceKey[]{key})), (Function1 & Serializable)x$2 -> x$2.serviceInstanceAdded(key, serviceInstance), state$1);
        }
        if (command instanceof ReceptionistMessages.Deregister) {
            Option<ActorRef<Receptionist.Deregistered>> option;
            ReceptionistMessages.Deregister deregister = (ReceptionistMessages.Deregister)command;
            ServiceKey key = deregister.key();
            ActorRef serviceInstance = deregister.serviceInstance();
            Option<ActorRef<Receptionist.Deregistered>> maybeReplyTo = deregister.replyTo();
            Set servicesForActor = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            if (servicesForActor.isEmpty()) {
                return Behaviors$.MODULE$.same();
            }
            package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx.log()), "Actor was deregistered: {} {}", key, serviceInstance);
            if (servicesForActor.$minus(key).isEmpty()) {
                ctx.unwatch(serviceInstance);
            }
            if ((option = maybeReplyTo) instanceof Some) {
                Some some = (Some)option;
                ActorRef replyTo = (ActorRef)some.value();
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Deregistered$.MODULE$.apply(key, serviceInstance));
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            return this.updateServices$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractServiceKey[]{key})), (Function1 & Serializable)state -> {
                LocalReceptionist.State newState;
                block0: {
                    newState = state.serviceInstanceRemoved(key, serviceInstance);
                    if (!((IterableOnceOps)state.servicesPerActor().getOrElse((Object)serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).isEmpty()) break block0;
                    ctx.unwatch(serviceInstance);
                }
                return newState;
            }, state$1);
        }
        if (command instanceof ReceptionistMessages.Find) {
            ReceptionistMessages.Find find = (ReceptionistMessages.Find)command;
            ServiceKey key = find.key();
            ActorRef<Receptionist.Listing> replyTo = find.replyTo();
            LocalReceptionist$.replyWithListing$1(key, replyTo, state$1);
            return Behaviors$.MODULE$.same();
        }
        if (command instanceof ReceptionistMessages.Subscribe) {
            ReceptionistMessages.Subscribe subscribe = (ReceptionistMessages.Subscribe)command;
            ServiceKey key = subscribe.key();
            ActorRef<Receptionist.Listing> subscriber = subscribe.subscriber();
            if (!state$1.subscriptionsPerActor().contains(subscriber)) {
                ctx.watchWith(subscriber, new LocalReceptionist.SubscriberTerminated(subscriber));
            }
            LocalReceptionist$.replyWithListing$1(key, subscriber, state$1);
            return this.behavior(state$1.subscriberAdded(key, subscriber));
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected command type ").append(command.getClass()).toString());
    }

    private final Behavior onInternal$1(ActorContext ctx, LocalReceptionist.InternalCommand cmd, LocalReceptionist.State state$1) {
        LocalReceptionist.InternalCommand internalCommand = cmd;
        if (internalCommand instanceof LocalReceptionist.RegisteredActorTerminated) {
            LocalReceptionist.RegisteredActorTerminated registeredActorTerminated = (LocalReceptionist.RegisteredActorTerminated)internalCommand;
            ActorRef serviceInstance = registeredActorTerminated.ref();
            Set keys = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            if (keys.isEmpty()) {
                return Behaviors$.MODULE$.same();
            }
            package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx.log()), "Registered actor terminated: [{}] {}", keys.mkString(","), serviceInstance);
            return this.updateServices$1(keys, (Function1 & Serializable)x$3 -> x$3.serviceInstanceRemoved(serviceInstance), state$1);
        }
        if (internalCommand instanceof LocalReceptionist.SubscriberTerminated) {
            LocalReceptionist.SubscriberTerminated subscriberTerminated = (LocalReceptionist.SubscriberTerminated)internalCommand;
            ActorRef subscriber = subscriberTerminated.ref();
            if (ctx.log().isDebugEnabled()) {
                Set keys = (Set)state$1.subscriptionsPerActor().getOrElse(subscriber, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx.log()), "Subscribed actor terminated: [{}] {}", keys.mkString(","), subscriber);
            }
            return this.behavior(state$1.subscriberRemoved(subscriber));
        }
        throw new MatchError((Object)internalCommand);
    }

    private LocalReceptionist$() {
    }
}

