/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.internal.routing;

import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.typed.ActorRef;
import akka.actor.typed.internal.routing.RoutingLogic;
import akka.annotation.InternalApi;
import akka.routing.ConsistentHash;
import akka.routing.ConsistentHash$;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]uA\u0002\u0012$\u0011\u0003YSF\u0002\u00040G!\u00051\u0006\r\u0005\u0006o\u0005!\t!\u000f\u0004\u0005u\u0005\u00111\bC\u00038\u0007\u0011\u00051\nC\u0005O\u0007\u0001\u0007\t\u0019!C\u0005\u001f\"Iqk\u0001a\u0001\u0002\u0004%I\u0001\u0017\u0005\n=\u000e\u0001\r\u0011!Q!\nACqaX\u0002A\u0002\u0013%\u0001\rC\u0004e\u0007\u0001\u0007I\u0011B3\t\r\u001d\u001c\u0001\u0015)\u0003b\u0011\u0015A7\u0001\"\u0001j\u0011\u0015a7\u0001\"\u0011n\r\u0011Y\u0018A\u0001?\t\r]jA\u0011AA\u0002\u0011)qU\u00021AA\u0002\u0013%\u0011q\u0001\u0005\u000b/6\u0001\r\u00111A\u0005\n\u00055\u0001B\u00030\u000e\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!1\u0001.\u0004C!\u0003#Aa\u0001\\\u0007\u0005B\u0005UaABA\u000e\u0003\t\ti\u0002C\u0005\u0002(Q\u0011\t\u0011)A\u0005C\"Q\u0011\u0011\u0006\u000b\u0003\u0002\u0003\u0006I!a\u000b\t\u0015\u0005]BC!A!\u0002\u0013\tI\u0004\u0003\u00048)\u0011\u0005\u0011\u0011\t\u0005\n\u0003\u0017\"\u0002\u0019!C\u0005\u0003\u001bB\u0011\"a\u0016\u0015\u0001\u0004%I!!\u0017\t\u0011\u0005uC\u0003)Q\u0005\u0003\u001fB\u0011\"a\u0018\u0015\u0001\u0004%I!!\u0019\t\u0013\u00055D\u00031A\u0005\n\u0005=\u0004\u0002CA:)\u0001\u0006K!a\u0019\t\r!$B\u0011IA;\u0011\u0019aG\u0003\"\u0011\u0002z!9\u0011q\u0010\u000b\u0005\n\u0005\u0005\u0015!\u0004*pkRLgn\u001a'pO&\u001c7O\u0003\u0002%K\u00059!o\\;uS:<'B\u0001\u0014(\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0015*\u0003\u0015!\u0018\u0010]3e\u0015\tQ3&A\u0003bGR|'OC\u0001-\u0003\u0011\t7n[1\u0011\u00059\nQ\"A\u0012\u0003\u001bI{W\u000f^5oO2{w-[2t'\t\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQFA\bS_VtGMU8cS:dunZ5d+\ta$iE\u0002\u0004cu\u00022A\f A\u0013\ty4E\u0001\u0007S_V$\u0018N\\4M_\u001eL7\r\u0005\u0002B\u00052\u0001A!B\"\u0004\u0005\u0004!%!\u0001+\u0012\u0005\u0015C\u0005C\u0001\u001aG\u0013\t95GA\u0004O_RD\u0017N\\4\u0011\u0005IJ\u0015B\u0001&4\u0005\r\te.\u001f\u000b\u0002\u0019B\u0019Qj\u0001!\u000e\u0003\u0005\tabY;se\u0016tGOU8vi\u0016,7/F\u0001Q!\r\u0011\u0014kU\u0005\u0003%N\u0012Q!\u0011:sCf\u00042\u0001V+A\u001b\u00059\u0013B\u0001,(\u0005!\t5\r^8s%\u00164\u0017AE2veJ,g\u000e\u001e*pkR,Wm]0%KF$\"!\u0017/\u0011\u0005IR\u0016BA.4\u0005\u0011)f.\u001b;\t\u000fu3\u0011\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\u0002\u001f\r,(O]3oiJ{W\u000f^3fg\u0002\nqA\\3yi&#\u00070F\u0001b!\t\u0011$-\u0003\u0002dg\t\u0019\u0011J\u001c;\u0002\u00179,\u0007\u0010^%eq~#S-\u001d\u000b\u00033\u001aDq!X\u0005\u0002\u0002\u0003\u0007\u0011-\u0001\u0005oKb$\u0018\n\u001a=!\u00031\u0019X\r\\3diJ{W\u000f^3f)\t\u0019&\u000eC\u0003l\u0017\u0001\u0007\u0001)A\u0002ng\u001e\faB]8vi\u0016,7/\u00169eCR,G\r\u0006\u0002Z]\")q\u000e\u0004a\u0001a\u0006Qa.Z<S_V$X-Z:\u0011\u0007ED8K\u0004\u0002smB\u00111oM\u0007\u0002i*\u0011Q\u000fO\u0001\u0007yI|w\u000e\u001e \n\u0005]\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002zu\n\u00191+\u001a;\u000b\u0005]\u001c$a\u0003*b]\u0012|W\u000eT8hS\u000e,2!`A\u0001'\ri\u0011G \t\u0004]yz\bcA!\u0002\u0002\u0011)1)\u0004b\u0001\tR\u0011\u0011Q\u0001\t\u0004\u001b6yXCAA\u0005!\u0011\u0011\u0014+a\u0003\u0011\u0007Q+v\u0010F\u0002Z\u0003\u001fA\u0001\"\u0018\t\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u000b\u0005\u0003\u0017\t\u0019\u0002C\u0003l%\u0001\u0007q\u0010F\u0002Z\u0003/Aaa\\\nA\u0002\u0005e\u0001\u0003B9y\u0003\u0017\u0011acQ8og&\u001cH/\u001a8u\u0011\u0006\u001c\b.\u001b8h\u0019><\u0017nY\u000b\u0005\u0003?\t)c\u0005\u0003\u0015c\u0005\u0005\u0002\u0003\u0002\u0018?\u0003G\u00012!QA\u0013\t\u0015\u0019EC1\u0001E\u0003I1\u0018N\u001d;vC2tu\u000eZ3t\r\u0006\u001cGo\u001c:\u0002\u000f5\f\u0007\u000f]5oOB9!'!\f\u0002$\u0005E\u0012bAA\u0018g\tIa)\u001e8di&|g.\r\t\u0004c\u0006M\u0012bAA\u001bu\n11\u000b\u001e:j]\u001e\f1BY1tK\u0006#GM]3tgB!\u00111HA\u001f\u001b\u0005I\u0013bAA S\t9\u0011\t\u001a3sKN\u001cH\u0003CA\"\u0003\u000b\n9%!\u0013\u0011\t5#\u00121\u0005\u0005\u0007\u0003OA\u0002\u0019A1\t\u000f\u0005%\u0002\u00041\u0001\u0002,!9\u0011q\u0007\rA\u0002\u0005e\u0012A\u00039bi\"$vNU3ggV\u0011\u0011q\n\t\bc\u0006E\u0013\u0011GA+\u0013\r\t\u0019F\u001f\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002+V\u0003G\ta\u0002]1uQR{'+\u001a4t?\u0012*\u0017\u000fF\u0002Z\u00037B\u0001\"\u0018\u000e\u0002\u0002\u0003\u0007\u0011qJ\u0001\fa\u0006$\b\u000eV8SK\u001a\u001c\b%\u0001\bd_:\u001c\u0018n\u001d;f]RD\u0015m\u001d5\u0016\u0005\u0005\r\u0004CBA3\u0003S\n\t$\u0004\u0002\u0002h)\u0011AeK\u0005\u0005\u0003W\n9G\u0001\bD_:\u001c\u0018n\u001d;f]RD\u0015m\u001d5\u0002%\r|gn]5ti\u0016tG\u000fS1tQ~#S-\u001d\u000b\u00043\u0006E\u0004\u0002C/\u001e\u0003\u0003\u0005\r!a\u0019\u0002\u001f\r|gn]5ti\u0016tG\u000fS1tQ\u0002\"B!!\u0016\u0002x!11n\ba\u0001\u0003G!2!WA>\u0011\u0019y\u0007\u00051\u0001\u0002~A!\u0011\u000f_A+\u0003M!xNR;mY\u0006#GM]3tgN#(/\u001b8h)\u0011\t\t$a!\t\u000f\u0005\u0015\u0015\u00051\u0001\u0002V\u00051!o\\;uK\u0016D3!AAE!\u0011\tY)!%\u000e\u0005\u00055%bAAHW\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eK\u0002\u0001\u0003\u0013\u0003")
@InternalApi
public final class RoutingLogics {

    public static final class ConsistentHashingLogic<T>
    implements RoutingLogic<T> {
        private final Function1<T, String> mapping;
        private final Address baseAddress;
        private Map<String, ActorRef<T>> pathToRefs;
        private ConsistentHash<String> consistentHash;

        private Map<String, ActorRef<T>> pathToRefs() {
            return this.pathToRefs;
        }

        private void pathToRefs_$eq(Map<String, ActorRef<T>> x$1) {
            this.pathToRefs = x$1;
        }

        private ConsistentHash<String> consistentHash() {
            return this.consistentHash;
        }

        private void consistentHash_$eq(ConsistentHash<String> x$1) {
            this.consistentHash = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            return (ActorRef)this.pathToRefs().apply(this.consistentHash().nodeFor((String)this.mapping.apply(msg)));
        }

        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            Map updatedPathToRefs = ((IterableOnceOps)newRoutees.map((Function1 & Serializable)routee -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toFullAddressString((ActorRef)routee)), routee))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            ConsistentHash withoutOld = (ConsistentHash)this.pathToRefs().keySet().diff((Set)updatedPathToRefs.keySet()).foldLeft(this.consistentHash(), (Function2 & Serializable)(x$3, x$4) -> x$3.$colon$minus(x$4));
            this.consistentHash_$eq((ConsistentHash<String>)((ConsistentHash)updatedPathToRefs.keySet().diff((Set)this.pathToRefs().keySet()).foldLeft((Object)withoutOld, (Function2 & Serializable)(x$5, x$6) -> x$5.$colon$plus(x$6))));
            this.pathToRefs_$eq(updatedPathToRefs);
        }

        private String toFullAddressString(ActorRef<T> routee) {
            Address address = routee.path().address();
            if (address != null) {
                Option option = address.host();
                Option option2 = address.port();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return routee.path().toStringWithAddress(this.baseAddress);
                }
            }
            return routee.path().toString();
        }

        public ConsistentHashingLogic(int virtualNodesFactor, Function1<T, String> mapping, Address baseAddress) {
            this.mapping = mapping;
            this.baseAddress = baseAddress;
            Predef$.MODULE$.require(virtualNodesFactor > 0, (Function0 & Serializable)() -> "virtualNodesFactor has to be a positive integer");
            this.pathToRefs = Predef$.MODULE$.Map().empty();
            this.consistentHash = ConsistentHash$.MODULE$.apply((Iterable)Predef$.MODULE$.Set().empty(), virtualNodesFactor, ClassTag$.MODULE$.apply(String.class));
        }
    }

    public static final class RandomLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;

        private ActorRef<T>[] currentRoutees() {
            return this.currentRoutees;
        }

        private void currentRoutees_$eq(ActorRef<T>[] x$1) {
            this.currentRoutees = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            int selectedIdx = ThreadLocalRandom.current().nextInt(this.currentRoutees().length);
            return this.currentRoutees()[selectedIdx];
        }

        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            this.currentRoutees_$eq((ActorRef[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class)));
        }
    }

    public static final class RoundRobinLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;
        private int nextIdx = 0;

        private ActorRef<T>[] currentRoutees() {
            return this.currentRoutees;
        }

        private void currentRoutees_$eq(ActorRef<T>[] x$1) {
            this.currentRoutees = x$1;
        }

        private int nextIdx() {
            return this.nextIdx;
        }

        private void nextIdx_$eq(int x$1) {
            this.nextIdx = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            if (this.nextIdx() >= this.currentRoutees().length) {
                this.nextIdx_$eq(0);
            }
            ActorRef<T> selected = this.currentRoutees()[this.nextIdx()];
            this.nextIdx_$eq(this.nextIdx() + 1);
            return selected;
        }

        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            ActorRef[] sortedNewRoutees = (ActorRef[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class))), (Function1 & Serializable)ref -> new Tuple2((Object)ref.path().toStringWithoutAddress(), (Object)ref.path().address()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, Address$.MODULE$.addressOrdering()));
            if (this.currentRoutees() != null) {
                int idx;
                for (idx = 0; idx < this.currentRoutees().length && idx < sortedNewRoutees.length; ++idx) {
                    ActorRef<T> actorRef = this.currentRoutees()[idx];
                    ActorRef actorRef2 = sortedNewRoutees[idx];
                    if (actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) break;
                }
                int firstDiffIndex = idx;
                if (this.nextIdx() > firstDiffIndex) {
                    this.nextIdx_$eq(this.nextIdx() - 1);
                }
            }
            this.currentRoutees_$eq(sortedNewRoutees);
        }
    }
}

