/*
 * Decompiled with CFR 0.152.
 */
package com.DeathByCaptcha;

import com.DeathByCaptcha.AccessDeniedException;
import com.DeathByCaptcha.Captcha;
import com.DeathByCaptcha.Client;
import com.DeathByCaptcha.Exception;
import com.DeathByCaptcha.InvalidCaptchaException;
import com.DeathByCaptcha.ServiceOverloadException;
import com.DeathByCaptcha.User;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClient
extends Client {
    public static final String CRLF = "\r\n";
    public static final String SERVER_URL = "http://api.dbcapi.me/api";
    public Proxy proxy = Proxy.NO_PROXY;

    protected JSONObject call(String cmd, byte[] data, String contentType) throws IOException, Exception {
        this.log("SEND", cmd);
        URL url = null;
        try {
            url = new URL("http://api.dbcapi.me/api/" + cmd);
        }
        catch (java.lang.Exception e) {
            throw new IOException("Invalid API command " + cmd);
        }
        String response = new HttpClientCaller().call(this.proxy, url, data, null != contentType ? contentType : "application/x-www-form-urlencoded", new Date(System.currentTimeMillis() + 60000L));
        this.log("RECV", response);
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new IOException("Invalid API response");
        }
    }

    protected JSONObject call(String cmd, byte[] data) throws IOException, Exception {
        return this.call(cmd, data, null);
    }

    protected JSONObject call(String cmd, JSONObject args) throws IOException, Exception {
        StringBuilder data = new StringBuilder();
        Iterator args_keys = args.keys();
        String k = null;
        while (args_keys.hasNext()) {
            k = args_keys.next().toString();
            try {
                data.append(URLEncoder.encode(k, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new JSONObject();
            }
            data.append("=");
            try {
                data.append(URLEncoder.encode(args.optString(k, ""), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new JSONObject();
            }
            if (!args_keys.hasNext()) continue;
            data.append("&");
        }
        return this.call(cmd, data.toString().getBytes());
    }

    protected JSONObject call(String cmd) throws IOException, Exception {
        return this.call(cmd, new byte[0]);
    }

    public HttpClient(String username, String password) {
        super(username, password);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean connect() throws IOException {
        return true;
    }

    @Override
    public User getUser() throws IOException, Exception {
        return new User(this.call("user", this.getCredentials()));
    }

    @Override
    public Captcha upload(byte[] img) throws IOException, Exception {
        String boundary = null;
        try {
            boundary = new BigInteger(1, MessageDigest.getInstance("SHA1").digest(new Date().toString().getBytes())).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] hdr = ("--" + boundary + CRLF + "Content-Disposition: form-data; name=\"username\"" + CRLF + "Content-Type: text/plain" + CRLF + "Content-Length: " + this._username.length() + CRLF + CRLF + this._username + CRLF + "--" + boundary + CRLF + "Content-Disposition: form-data; name=\"password\"" + CRLF + "Content-Type: text/plain" + CRLF + "Content-Length: " + this._password.length() + CRLF + CRLF + this._password + CRLF + "--" + boundary + CRLF + "Content-Disposition: form-data; name=\"swid\"" + CRLF + "Content-Type: text/plain" + CRLF + CRLF + 0 + CRLF + "--" + boundary + CRLF + "Content-Disposition: form-data; name=\"captchafile\"; filename=\"captcha\"" + CRLF + "Content-Type: application/octet-stream" + CRLF + "Content-Length: " + img.length + CRLF + CRLF).getBytes();
        byte[] ftr = ("\r\n--" + boundary + "--").getBytes();
        byte[] body = new byte[hdr.length + img.length + ftr.length];
        System.arraycopy(hdr, 0, body, 0, hdr.length);
        System.arraycopy(img, 0, body, hdr.length, img.length);
        System.arraycopy(ftr, 0, body, hdr.length + img.length, ftr.length);
        Captcha c = new Captcha(this.call("captcha", body, "multipart/form-data; boundary=" + boundary));
        return c.isUploaded() ? c : null;
    }

    @Override
    public Captcha getCaptcha(int id) throws IOException, Exception {
        return new Captcha(this.call("captcha/" + id));
    }

    @Override
    public boolean report(int id) throws IOException, Exception {
        return !new Captcha(this.call("captcha/" + id + "/report", this.getCredentials())).isCorrect();
    }

    private class HttpClientCaller {
        public static final String RESPONSE_CONTENT_TYPE = "application/json";

        private HttpClientCaller() {
        }

        public String call(Proxy proxy, URL url, byte[] payload, String contentType, Date deadline) throws IOException, Exception {
            String response = null;
            while (deadline.after(new Date()) && null != url && null == response) {
                HttpURLConnection req = null;
                try {
                    req = (HttpURLConnection)url.openConnection(proxy);
                }
                catch (IOException e) {
                    throw new IOException("API connection failed: " + e.toString());
                }
                req.setRequestProperty("Accept", RESPONSE_CONTENT_TYPE);
                req.setRequestProperty("User-Agent", "DBC/Java v4.1.0");
                req.setInstanceFollowRedirects(false);
                if (0 < payload.length) {
                    try {
                        req.setRequestMethod("POST");
                    }
                    catch (java.lang.Exception e) {
                        // empty catch block
                    }
                    req.setRequestProperty("Content-Type", contentType);
                    req.setRequestProperty("Content-Length", String.valueOf(payload.length));
                    req.setDoOutput(true);
                    OutputStream st = null;
                    try {
                        st = req.getOutputStream();
                        st.write(payload);
                        st.flush();
                    }
                    catch (IOException e) {
                        throw new IOException("Failed sending API request: " + e.toString());
                    }
                    finally {
                        try {
                            st.close();
                        }
                        catch (java.lang.Exception e) {}
                    }
                    payload = new byte[]{};
                } else {
                    try {
                        req.setRequestMethod("GET");
                    }
                    catch (java.lang.Exception e) {
                        // empty catch block
                    }
                }
                url = null;
                req.setConnectTimeout(15000);
                req.setReadTimeout(15000);
                try {
                    req.connect();
                }
                catch (IOException e) {
                    throw new IOException("API connection failed: " + e.toString());
                }
                try {
                    int responseLength = 0;
                    int i = 1;
                    String k = null;
                    while (null != (k = req.getHeaderFieldKey(i))) {
                        if (k.equals("Content-Length")) {
                            responseLength = Integer.parseInt(req.getHeaderField(i), 10);
                        } else if (k.equals("Location")) {
                            try {
                                url = new URL(req.getHeaderField(i));
                            }
                            catch (java.lang.Exception e) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    switch (req.getResponseCode()) {
                        case 403: {
                            throw new AccessDeniedException("Access denied, check your credentials and/or balance");
                        }
                        case 400: {
                            throw new InvalidCaptchaException("CAPTCHA was rejected, check if it's a valid image");
                        }
                        case 503: {
                            throw new ServiceOverloadException("CAPTCHA was rejected due to service overload, try again later");
                        }
                        case 303: {
                            if (null != url) break;
                            throw new IOException("Invalid API redirection response");
                        }
                    }
                    InputStream st = null;
                    try {
                        st = req.getInputStream();
                    }
                    catch (IOException e) {
                        st = null;
                    }
                    catch (java.lang.Exception e) {
                        st = req.getErrorStream();
                    }
                    if (null == st) {
                        throw new IOException("Failed receiving API response");
                    }
                    byte[] buff = new byte[responseLength];
                    try {
                        for (int offset = 0; responseLength > offset; offset += st.read(buff, offset, responseLength - offset)) {
                        }
                        st.close();
                    }
                    catch (IOException e) {
                        throw new IOException("Failed receiving API response: " + e.toString());
                    }
                    if (0 >= buff.length) continue;
                    response = new String(buff, 0, buff.length);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (java.lang.Exception e) {
                    throw new IOException("API communication failed: " + e.toString());
                }
                finally {
                    try {
                        req.disconnect();
                    }
                    catch (java.lang.Exception e) {}
                }
            }
            return response;
        }
    }
}

