/*
 * Decompiled with CFR 0.152.
 */
package imageserviceclient;

import com.DeathByCaptcha.Captcha;
import com.DeathByCaptcha.SocketClient;
import imageserviceclient.AntigateDecoder;
import imageserviceclient.ImageServiceConfig;
import imageserviceclient.exception.UnauthorizedException;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServiceAgent {
    private static final Logger log = LoggerFactory.getLogger(ImageServiceAgent.class);
    private static ImageServiceAgent _inst;
    private static ImageServiceConfig config;
    public static final String FAILED_MESSAGE = "Failed to upload image";

    private ImageServiceAgent() {
    }

    public static ImageServiceAgent instance(String configFilePath) throws Exception {
        config = ImageServiceConfig.instance();
        config.loadWithoutEncrpt(configFilePath);
        return ImageServiceAgent.instance();
    }

    public static ImageServiceAgent instance() {
        if (_inst == null) {
            _inst = new ImageServiceAgent();
        }
        return _inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processImageRest(String imagePath) throws UnauthorizedException, Exception {
        String url = config.getProcessImageUrl();
        int port = config.getPort();
        String username = config.getUsername();
        String password = config.getPassword();
        DefaultHttpClient httpclient = ImageServiceAgent.createHttpClient(port);
        HttpPost post = new HttpPost(url);
        try {
            File image = new File(imagePath);
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("image", (ContentBody)new FileBody(image));
            String authKey = ImageServiceAgent.getHash(username, password, new Date());
            entity.addPart("username", (ContentBody)new StringBody(username, Charset.forName("UTF-8")));
            entity.addPart("authkey", (ContentBody)new StringBody(authKey, Charset.forName("UTF-8")));
            post.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            InputStream instream = response.getEntity().getContent();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)instream, (Writer)writer);
            String result = writer.toString();
            if (result.contains("Authorization failed")) {
                throw new UnauthorizedException();
            }
            String string = String.format("%s", result.trim());
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    private void sendLogRequestToImageRest(String filename) {
        int port = config.getPort();
        String username = config.getUsername();
        String password = config.getPassword();
        String loggingUrl = config.getLoggingUrl();
        String authKey = ImageServiceAgent.getHash(username, password, new Date());
        HttpPost post = new HttpPost(loggingUrl);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("username", username));
        nvps.add(new BasicNameValuePair("authkey", authKey));
        nvps.add(new BasicNameValuePair("filename", filename));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            DefaultHttpClient httpClient = ImageServiceAgent.createHttpClient(port);
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String processImageAntigate(String imagePath) throws Exception {
        log.info("Using antigate to decode {}", (Object)imagePath);
        this.sendLogRequestToImageRest(imagePath);
        AntigateDecoder decoder = new AntigateDecoder();
        String key = config.getAntigate_key();
        File file = new File(imagePath);
        int numRetry = 3;
        String result = decoder.getCaptcha(file, key, numRetry);
        if (result.contains("ERROR_NO_SLOT_AVAILABLE")) {
            log.info("No slot error after {} retries, switching to DeathByCaptcha", (Object)numRetry);
            return this.processImageDeath(imagePath);
        }
        return String.format("%s", result.trim());
    }

    public String processImageDeath(String imagepath) throws Exception {
        SocketClient client = new SocketClient(config.getUser(), config.getPwd());
        Captcha captha = client.decode(imagepath, 30);
        return captha.text.trim();
    }

    public void error(String mark, Exception ex) {
        System.out.println("imageserviceclient.ImageServiceAgent: " + mark);
        ex.printStackTrace();
    }

    private static DefaultHttpClient createHttpClient(int port) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme httpsScheme = new Scheme("https", port, (SchemeSocketFactory)sf);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(httpsScheme);
            BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
            return new DefaultHttpClient((ClientConnectionManager)cm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static String getHash(String username, String password, Date time) {
        StringBuilder builder = new StringBuilder();
        builder.append(username).append('_');
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0:00"));
        String date1 = dateFormat.format(time);
        builder.append(date1).append('_');
        builder.append(password).append('_');
        dateFormat = new SimpleDateFormat("HH/mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0:00"));
        String date2 = dateFormat.format(time);
        builder.append(date2);
        try {
            byte[] bytesOfMessage = builder.toString().getBytes("utf-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] theDigest = md.digest(bytesOfMessage);
            String result = new String(Hex.encodeHex((byte[])theDigest));
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

