/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.streamfinder.internal.StreamJson;

public final class Advertisement {
    final Set<StreamJson> advertisements;

    public Advertisement() {
        this.advertisements = new HashSet<StreamJson>();
    }

    public Advertisement(Collection<StreamJson> advertisements) {
        this.advertisements = new HashSet<StreamJson>(advertisements);
    }

    public Advertisement advertise(String group, String stream, int level) {
        HashSet<StreamJson> updatedAds = new HashSet<StreamJson>(this.advertisements);
        StreamJson record = new StreamJson(group, stream, level);
        updatedAds.remove(record);
        updatedAds.add(record);
        return new Advertisement(updatedAds);
    }

    public Advertisement advertise(String group, String stream) {
        return this.advertise(group, stream, 0);
    }

    public Advertisement remove(String group) {
        Set<StreamJson> updatedAds = this.advertisements.stream().filter(advert -> !advert.getGroup().equals(group)).collect(Collectors.toSet());
        return new Advertisement(updatedAds);
    }

    public Advertisement remove(String group, String stream) {
        HashSet<StreamJson> updatedAds = new HashSet<StreamJson>(this.advertisements);
        updatedAds.remove(new StreamJson(group, stream, 0));
        return new Advertisement(updatedAds);
    }

    public Advertisement clear() {
        return new Advertisement();
    }

    public List<StreamJson> getAdvertisements() {
        return new ArrayList<StreamJson>(this.advertisements);
    }
}

