/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import jayeson.lib.streamfinder.Advertiser;
import jayeson.lib.streamfinder.AdvertiserFactory;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.lib.streamfinder.internal.AdvertChannel;
import jayeson.lib.streamfinder.internal.DiscoveryClient;
import jayeson.lib.streamfinder.internal.DiscoveryClientFactory;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

public class AdvertiserFactoryImpl
implements AdvertiserFactory {
    final DiscoveryClientFactory clientFactory;
    final Provider<AdvertChannel> channelProvider;

    @Inject
    public AdvertiserFactoryImpl(DiscoveryClientFactory clientFactory, Provider<AdvertChannel> channelProvider) {
        this.clientFactory = clientFactory;
        this.channelProvider = channelProvider;
    }

    @Override
    public Advertiser create(StreamfinderConfig config) {
        return this.create(config, null);
    }

    @Override
    public Advertiser create(String file) {
        return this.create(AdvertiserFactoryImpl.config(file));
    }

    @Override
    public Advertiser create(String username, String password, String discoveryUrl, String serviceId) {
        return this.create(username, password, discoveryUrl, serviceId, null);
    }

    @Override
    public Advertiser create(String username, String password, String discoveryUrl, String serviceId, String scope) {
        StreamfinderConfig conf = new StreamfinderConfig();
        conf.setUsername(username);
        conf.setPassword(password);
        conf.setDiscoveryUri(discoveryUrl);
        conf.setServiceId(serviceId);
        return this.create(conf, scope);
    }

    @Override
    public Advertiser create(StreamfinderConfig config, String scope) {
        String user = config.getUsername();
        String pass = config.getPassword();
        String url = config.getDiscoveryUri();
        long advertRateS = config.getPollRateS();
        if (advertRateS < 0L) {
            throw new IllegalArgumentException("Invalid advertisement keep alive rate");
        }
        DiscoveryClient client = this.clientFactory.create(user, pass, url);
        AdvertChannel channel = (AdvertChannel)this.channelProvider.get();
        channel.setDiscoveryClient(client);
        channel.setAdvertRateS(advertRateS);
        channel.start();
        return new Advertiser(config, scope, channel);
    }

    @Override
    public Advertiser create(String username, String password, String discoveryUrl, String serviceId, long pollRateS) {
        StreamfinderConfig conf = new StreamfinderConfig();
        conf.setUsername(username);
        conf.setPassword(password);
        conf.setDiscoveryUri(discoveryUrl);
        conf.setServiceId(serviceId);
        conf.setPollRateS(pollRateS);
        return this.create(conf, null);
    }

    static StreamfinderConfig config(String filename) {
        return (StreamfinderConfig)JacksonConfig.readConfig((String)filename, null, StreamfinderConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
    }
}

