/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import jayeson.lib.streamfinder.internal.StreamJson;

public final class SourceJson
implements Comparable<SourceJson> {
    final URI connection;
    private final String serviceId;
    @JsonIgnore
    final StreamJson streamPair;

    @JsonCreator
    public SourceJson(@JsonProperty(value="group") String groupName, @JsonProperty(value="stream") String streamName, @JsonProperty(value="level") int level, @JsonProperty(value="serviceId") String serviceId, @JsonProperty(value="connection") URI connections) {
        if (groupName == null || streamName == null || serviceId == null || connections == null) {
            throw new IllegalArgumentException("Group, stream, serviceId and connection cannot be null");
        }
        this.streamPair = new StreamJson(groupName, streamName, level);
        this.serviceId = serviceId;
        this.connection = connections;
    }

    @JsonProperty(value="group")
    public String getGroupName() {
        return this.streamPair.getGroup();
    }

    @JsonProperty(value="stream")
    public String getStreamName() {
        return this.streamPair.getStream();
    }

    @JsonProperty(value="connection")
    public URI getConnection() {
        return this.connection;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public StreamJson getStreamPair() {
        return this.streamPair;
    }

    public int getLevel() {
        return this.streamPair.getLevel();
    }

    @Override
    public int compareTo(SourceJson o) {
        return this.streamPair.compareTo(o.streamPair);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.streamPair == null ? 0 : this.streamPair.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceJson other = (SourceJson)obj;
        return !(this.streamPair == null ? other.streamPair != null : !this.streamPair.equals(other.streamPair));
    }

    public String toString() {
        return "StreamSource [connections=" + this.connection + ", streamPair=" + this.streamPair + "]";
    }
}

