/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class StreamJson
implements Comparable<StreamJson> {
    final String group;
    final String stream;
    final int level;

    public StreamJson(String group, String stream) {
        this(group, stream, 0);
    }

    @JsonCreator
    public StreamJson(@JsonProperty(value="group") String group, @JsonProperty(value="stream") String stream, @JsonProperty(value="level") int level) {
        if (group == null || stream == null) {
            throw new IllegalArgumentException("Group or stream cannot be null");
        }
        if (level < 0) {
            throw new IllegalArgumentException("Level cannot be less than 0");
        }
        this.group = group;
        this.stream = stream;
        this.level = level;
    }

    public String getGroup() {
        return this.group;
    }

    public String getStream() {
        return this.stream;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int compareTo(StreamJson o) {
        int groupCompare = this.group.compareTo(o.group);
        if (groupCompare == 0) {
            return this.stream.compareTo(o.stream);
        }
        return groupCompare;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.stream == null ? 0 : this.stream.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamJson other = (StreamJson)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.stream == null ? other.stream != null : !this.stream.equals(other.stream));
    }

    public String toString() {
        return "StreamTuple [group=" + this.group + ", stream=" + this.stream + ", level=" + this.level + "]";
    }
}

