﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Threading.Tasks;
using System.Net.Sockets;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace CsDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            string HOST = "localhost";
            int PORT = 8992;

            try
            {
                TcpClient tcpclnt = new TcpClient();

                Console.WriteLine("Connecting to " + HOST + ":" + PORT);

                tcpclnt.Connect(HOST, PORT);
                // use the ipaddress as in the server program

                Console.WriteLine("Connected");
                string str = "{\"type\":\"SUBSCRIBE\"}";
                Stream stm = tcpclnt.GetStream();

                ASCIIEncoding asen = new ASCIIEncoding();
                byte[] ba = asen.GetBytes(str);
                Console.WriteLine("Transmitting.....");
                stm.Write(ba, 0, ba.Length);
                

                using (var reader = new StreamReader(stm, Encoding.UTF8))
                using (var jsonReader = new JsonTextReader(reader))
                {
                    jsonReader.SupportMultipleContent = true;
                    var serializer = new JsonSerializer();
                    while (true)
                    {
                        if (!jsonReader.Read())
                        {
                            break;
                        }
                        try
                        {
                            var token = serializer.Deserialize<JToken>(jsonReader);
                            if (token != null)
                            {
                                processMessage(token.ToString(Formatting.Indented));
                            }
                        }
                        catch (JsonReaderException e)
                        {
                            Console.WriteLine("JSON Parse Error: " + e.Message);
                            break; // Change break to continue if wanna continue
                        }
                    }
                }

            }
            catch (Exception e)
            {
                Console.WriteLine("Error..... " + e.StackTrace);
            }
        }

        static void processMessage(string msg)
        {
            Console.WriteLine(msg);
            //Process the feed messages here
        }
    }
}
