package main

import (
	"encoding/json"
	"fmt"
	"net"
	"os"
)

func main() {
	const HOST = "localhost"
	const PORT = "8992"

	fmt.Printf("Connecting to %s:%s\n", HOST, PORT)
	conn, err := net.Dial("tcp", HOST+":"+PORT)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Couldn't connect: %v\n", err)
		os.Exit(1)
	}
	defer conn.Close()

	fmt.Println("Connected")

	input := "{\"type\":\"SUBSCRIBE\"}"
	fmt.Println("Transmitting.....")
	_, err = conn.Write([]byte(input))
	if err != nil {
		fmt.Fprintf(os.Stderr, "Couldn't write: %v\n", err)
		os.Exit(1)
	}

	// Decode
	decoder := json.NewDecoder(conn)

	for {
		var msg map[string]interface{}

		err := decoder.Decode(&msg)
		if err != nil {
			fmt.Fprintf(os.Stderr, "JSON Decode error: %v\n", err)
			break
		}

		processMessage(msg)
	}
}

func processMessage(msg map[string]interface{}) {
	fmt.Println("Received msg:")
	pretty, _ := json.MarshalIndent(msg, "", "  ")
	fmt.Println(string(pretty))
	fmt.Println()
}
