require 'socket'
require 'yajl'
require 'json'

def send_subscribe_message(socket)
   subscribe_message = '{"type":"SUBSCRIBE"}'
   puts "Sending subscribe message..."
   socket.puts(subscribe_message)
end

def read_message_stream(socket)
   parser = Yajl::Parser.new

   parser.on_parse_complete = lambda do |obj|
      process_message(JSON.pretty_generate(obj))
   end

   begin
      parser << socket.readpartial(16384) while true
   rescue EOFError
      # Stream closed
   rescue => e
      $stderr.puts "Unexpected error: #{e}"
      $stderr.puts e.backtrace.join("\n")
   end
end

def process_message(message)
   puts "Received message: #{message}\n"
end

# Main
host = 'localhost'
port = 8992

puts "Connecting to #{host}:#{port}"

begin
   socket = TCPSocket.new(host, port)
   puts "Connected"

   send_subscribe_message(socket)
   read_message_stream(socket)

   socket.close
rescue SocketError => e
   $stderr.puts "Don't know about host: #{host}"
   $stderr.puts e.message
   exit 1
rescue SystemCallError => e
   $stderr.puts "Couldn't get I/O for the connection to: #{host}"
   $stderr.puts e.message
   exit 1
rescue Exception => e
   $stderr.puts "Unexpected error: #{e}"
   $stderr.puts e.backtrace.join("\n")
   exit 1
end
