import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.*;
import java.net.Socket;
import java.net.UnknownHostException;

public class JavaDemo {

	public static void main(String[] args) {
		String host = "localhost";
		int port = 8992;

		System.out.println("Connecting to " + host + ":" + port);

		try (Socket socket = new Socket(host, port)) {
			System.out.println("Connected");

			sendSubscribeMessage(socket.getOutputStream());

			readMessageStream(socket.getInputStream());

		} catch (UnknownHostException e) {
			System.err.println("Don't know about host:" + host);
			System.exit(1);
		} catch (IOException e) {
			System.err.println("Couldn't get I/O for the connection to:" + host);
			System.exit(1);
		} catch (Exception e) {
			System.err.println("Unexpected error: " + e);
			e.printStackTrace(System.err);
			System.exit(1);
		}
	}

	private static void sendSubscribeMessage(OutputStream outputStream) {
		PrintWriter output = new PrintWriter(new OutputStreamWriter(outputStream), true);
		String subscribeMessage = "{\"type\":\"SUBSCRIBE\"}";
		System.out.println("Sending subscribe message...");
		output.println(subscribeMessage);
	}

	public static void readMessageStream(InputStream inputStream) throws IOException {
		ObjectMapper mapper = new ObjectMapper();
		JsonFactory factory = mapper.getFactory();

		try (JsonParser parser = factory.createParser(inputStream)) {
			while (!parser.isClosed()) {
				JsonToken token = parser.nextToken();

				if (token == JsonToken.START_OBJECT) {
					JsonNode node = mapper.readTree(parser);
					processMessage(node.toPrettyString());
				}
			}
		}
	}

	public static void processMessage(String message) {
		System.out.println("Received message: " + message + "\n");
	}
}