const net = require('net');
const JSONParser = require('./node_modules/jsonparse/jsonparse');

const HOST = 'localhost';
const PORT = 8992;

const parser = new JSONParser();
let client = new net.Socket();

console.log(`Connecting to ${HOST}:${PORT}`);
client.connect(PORT, HOST, () => {
  console.log('Socket connected');
  client.write(JSON.stringify({ type: "SUBSCRIBE" }));
});

client.on('data', function (data) {
  parser.write(data);
});

parser.onValue = function (value) {
  if (this.stack.length === 0) {
    processMessage(value);
  }
};

// Write message 
function processMessage(msg) {
  console.log('Received Msg:', msg.type || '(No type)', '\n', msg);
}
