import socket
import json
import sys

def send_subscribe_message(sock):
    subscribe_message = {"type": "SUBSCRIBE"}
    message = json.dumps(subscribe_message)
    print("Sending subscribe message...")
    sock.sendall(message.encode('utf-8'))

def process_message(msg):
    print("Received message:")
    print(json.dumps(msg, indent=2))

def read_message_stream(sock):
    decoder = json.JSONDecoder()
    buffer = ""

    while True:
        try:
            data = sock.recv(16384).decode('utf-8')
            if not data:
                break

            buffer += data

            # Parse multiple JSON-formatted messages from the buffer
            while buffer:
                try:
                    obj, idx = decoder.raw_decode(buffer)
                    buffer = buffer[idx:].lstrip()
                    process_message(obj)
                except ValueError:
                    # Not enough data to parse a complete JSON object yet, wait for more
                    break

        except Exception as e:
            print("Error while reading data: %s" % str(e))
            break

def main():
    host = 'localhost'
    port = 8992

    print("Connecting to %s:%d..." % (host, port))

    try:
        sock = socket.create_connection((host, port))
        print("Connected")

        send_subscribe_message(sock)
        read_message_stream(sock)

        sock.close()

    except socket.gaierror:
        print("Unknown host: %s" % host)
        sys.exit(1)
    except Exception as e:
        print("Unexpected error: %s" % str(e))
        sys.exit(1)


if __name__ == "__main__":
    main()
